/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.EventObject;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Producer;
import org.apache.camel.management.EventNotifierSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;

public class PublishEventNotifier
extends EventNotifierSupport
implements CamelContextAware {
    private CamelContext camelContext;
    private Endpoint endpoint;
    private String endpointUri;
    private Producer producer;

    public void notify(EventObject event) throws Exception {
        Exchange exchange = this.producer.createExchange();
        exchange.getIn().setBody(event);
        this.producer.process(exchange);
    }

    public boolean isEnabled(EventObject event) {
        return true;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public String getEndpointUri() {
        return this.endpointUri;
    }

    public void setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull(this.camelContext, "camelContext", this);
        if (this.endpoint == null && this.endpointUri == null) {
            throw new IllegalArgumentException("Either endpoint or endpointUri must be configured");
        }
        if (this.endpoint == null) {
            this.endpoint = this.camelContext.getEndpoint(this.endpointUri);
        }
        this.producer = this.endpoint.createProducer();
        ServiceHelper.startService(this.producer);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.producer);
    }

    public String toString() {
        return "PublishEventNotifier[" + (this.endpoint != null ? this.endpoint.getEndpointUri() : this.endpointUri) + "]";
    }
}

