/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import java.lang.reflect.Method;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.cxf.jaxrs.CxfRsBinding;
import org.apache.camel.component.cxf.jaxrs.CxfRsEndpoint;
import org.apache.cxf.jaxrs.JAXRSInvoker;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;

public class CxfRsInvoker
extends JAXRSInvoker {
    private Processor processor;
    private CxfRsEndpoint endpoint;

    public CxfRsInvoker(CxfRsEndpoint endpoint, Processor processor) {
        this.endpoint = endpoint;
        this.processor = processor;
    }

    protected Object performInvocation(org.apache.cxf.message.Exchange cxfExchange, Object serviceObject, Method method, Object[] paramArray) throws Exception {
        paramArray = this.insertExchange(method, paramArray, cxfExchange);
        OperationResourceInfo ori = (OperationResourceInfo)cxfExchange.get(OperationResourceInfo.class);
        if (ori.isSubResourceLocator()) {
            return method.invoke(serviceObject, paramArray);
        }
        ExchangePattern ep = ExchangePattern.InOut;
        if (method.getReturnType() == Void.class) {
            ep = ExchangePattern.InOnly;
        }
        Exchange camelExchange = this.endpoint.createExchange(ep);
        CxfRsBinding binding = this.endpoint.getBinding();
        binding.populateExchangeFromCxfRsRequest(cxfExchange, camelExchange, method, paramArray);
        try {
            this.processor.process(camelExchange);
        }
        catch (Exception exception) {
            camelExchange.setException((Throwable)exception);
        }
        if (camelExchange.getException() != null) {
            Throwable exception = camelExchange.getException();
            Response result = null;
            if (exception instanceof RuntimeCamelException) {
                exception = ((RuntimeCamelException)exception).getCause();
            }
            if (exception instanceof WebApplicationException) {
                result = ((WebApplicationException)exception).getResponse();
            }
            return result;
        }
        return binding.populateCxfRsResponseFromExchange(camelExchange, cxfExchange);
    }
}

