/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.event;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.drools.common.InternalKnowledgeRuntime;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.WorkingMemoryAction;
import org.drools.marshalling.impl.MarshallerReaderContext;
import org.drools.marshalling.impl.MarshallerWriteContext;
import org.drools.marshalling.impl.ProtobufMessages;
import org.drools.runtime.process.EventListener;
import org.drools.runtime.process.ProcessInstance;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.event.SignalManager;

public class DefaultSignalManager
implements SignalManager {
    private Map<String, List<EventListener>> processEventListeners;
    private InternalKnowledgeRuntime kruntime;

    public DefaultSignalManager(InternalKnowledgeRuntime kruntime) {
        this.kruntime = kruntime;
    }

    public InternalKnowledgeRuntime getKnowledgeRuntime() {
        return this.kruntime;
    }

    public void addEventListener(String type, EventListener eventListener) {
        List<EventListener> eventListeners;
        if (this.processEventListeners == null) {
            this.processEventListeners = new HashMap<String, List<EventListener>>();
        }
        if ((eventListeners = this.processEventListeners.get(type)) == null) {
            eventListeners = new CopyOnWriteArrayList<EventListener>();
            this.processEventListeners.put(type, eventListeners);
        }
        eventListeners.add(eventListener);
    }

    public void removeEventListener(String type, EventListener eventListener) {
        List<EventListener> eventListeners;
        if (this.processEventListeners != null && (eventListeners = this.processEventListeners.get(type)) != null) {
            eventListeners.remove(eventListener);
        }
    }

    public void signalEvent(String type, Object event) {
        this.kruntime.queueWorkingMemoryAction((WorkingMemoryAction)new SignalAction(type, event));
        this.kruntime.executeQueuedActions();
    }

    public void internalSignalEvent(String type, Object event) {
        List<EventListener> eventListeners;
        if (this.processEventListeners != null && (eventListeners = this.processEventListeners.get(type)) != null) {
            for (EventListener eventListener : eventListeners) {
                eventListener.signalEvent(type, event);
            }
        }
    }

    public void signalEvent(long processInstanceId, String type, Object event) {
        ProcessInstance processInstance = this.kruntime.getProcessInstance(processInstanceId);
        if (processInstance != null) {
            this.kruntime.queueWorkingMemoryAction((WorkingMemoryAction)new SignalProcessInstanceAction(processInstanceId, type, event));
            this.kruntime.executeQueuedActions();
        }
    }

    public static class SignalAction
    implements WorkingMemoryAction {
        private String type;
        private Object event;

        public SignalAction(String type, Object event) {
            this.type = type;
            this.event = event;
        }

        public SignalAction(MarshallerReaderContext context) throws IOException, ClassNotFoundException {
            this.type = context.readUTF();
            if (context.readBoolean()) {
                this.event = context.readObject();
            }
        }

        public void execute(InternalWorkingMemory workingMemory) {
            ((DefaultSignalManager)((InternalProcessRuntime)workingMemory.getProcessRuntime()).getSignalManager()).internalSignalEvent(this.type, this.event);
        }

        public void execute(InternalKnowledgeRuntime kruntime) {
            ((DefaultSignalManager)((InternalProcessRuntime)kruntime.getProcessRuntime()).getSignalManager()).internalSignalEvent(this.type, this.event);
        }

        public void write(MarshallerWriteContext context) throws IOException {
            context.writeInt(7);
            context.writeUTF(this.type);
            context.writeBoolean(this.event != null);
            if (this.event != null) {
                context.writeObject(this.event);
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readUTF();
            if (in.readBoolean()) {
                this.event = in.readObject();
            }
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.type);
            out.writeBoolean(this.event != null);
            if (this.event != null) {
                out.writeObject(this.event);
            }
        }

        public ProtobufMessages.ActionQueue.Action serialize(MarshallerWriteContext context) throws IOException {
            return null;
        }
    }

    public static class SignalProcessInstanceAction
    implements WorkingMemoryAction {
        private long processInstanceId;
        private String type;
        private Object event;

        public SignalProcessInstanceAction(long processInstanceId, String type, Object event) {
            this.processInstanceId = processInstanceId;
            this.type = type;
            this.event = event;
        }

        public SignalProcessInstanceAction(MarshallerReaderContext context) throws IOException, ClassNotFoundException {
            this.processInstanceId = context.readLong();
            this.type = context.readUTF();
            if (context.readBoolean()) {
                this.event = context.readObject();
            }
        }

        public void execute(InternalWorkingMemory workingMemory) {
            ProcessInstance processInstance = workingMemory.getProcessInstance(this.processInstanceId);
            if (processInstance != null) {
                processInstance.signalEvent(this.type, this.event);
            }
        }

        public void execute(InternalKnowledgeRuntime kruntime) {
            ProcessInstance processInstance = kruntime.getProcessInstance(this.processInstanceId);
            if (processInstance != null) {
                processInstance.signalEvent(this.type, this.event);
            }
        }

        public void write(MarshallerWriteContext context) throws IOException {
            context.writeInt(6);
            context.writeLong(this.processInstanceId);
            context.writeUTF(this.type);
            context.writeBoolean(this.event != null);
            if (this.event != null) {
                context.writeObject(this.event);
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.processInstanceId = in.readLong();
            this.type = in.readUTF();
            if (in.readBoolean()) {
                this.event = in.readObject();
            }
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.processInstanceId);
            out.writeUTF(this.type);
            out.writeBoolean(this.event != null);
            if (this.event != null) {
                out.writeObject(this.event);
            }
        }

        public ProtobufMessages.ActionQueue.Action serialize(MarshallerWriteContext context) throws IOException {
            return null;
        }
    }
}

