/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet.servicelist;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.servlet.servicelist.ServiceListWriter;

public class UnformattedServiceListWriter
implements ServiceListWriter {
    boolean renderWsdlList;

    public UnformattedServiceListWriter(boolean renderWsdlList) {
        this.renderWsdlList = renderWsdlList;
    }

    public String getContentType() {
        return "text/html; charset=UTF-8";
    }

    public void writeServiceList(PrintWriter writer, AbstractDestination[] soapDestinations, AbstractDestination[] restDestinations) throws IOException {
        if (soapDestinations.length > 0 || restDestinations.length > 0) {
            this.writeUnformattedSOAPEndpoints(writer, soapDestinations);
            this.writeUnformattedRESTfulEndpoints(writer, restDestinations);
        } else {
            writer.write("No services have been found.");
        }
    }

    private void writeUnformattedSOAPEndpoints(PrintWriter writer, AbstractDestination[] destinations) throws IOException {
        for (AbstractDestination sd : destinations) {
            String address = sd.getEndpointInfo().getAddress();
            writer.write(address);
            if (this.renderWsdlList) {
                writer.write("?wsdl");
            }
            writer.write(10);
        }
        writer.write(10);
    }

    private void writeUnformattedRESTfulEndpoints(PrintWriter writer, AbstractDestination[] destinations) throws IOException {
        for (AbstractDestination sd : destinations) {
            String address = sd.getEndpointInfo().getAddress();
            writer.write(address + "?_wadl&_type=xml\n");
        }
    }
}

