/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.processor.ErrorHandlerSupport;
import org.apache.camel.processor.Logger;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.EventHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ServiceHelper;

public abstract class RedeliveryErrorHandler
extends ErrorHandlerSupport
implements AsyncProcessor {
    private static ScheduledExecutorService executorService;
    protected final CamelContext camelContext;
    protected final Processor deadLetter;
    protected final String deadLetterUri;
    protected final Processor output;
    protected final AsyncProcessor outputAsync;
    protected final Processor redeliveryProcessor;
    protected final RedeliveryPolicy redeliveryPolicy;
    protected final Predicate handledPolicy;
    protected final Logger logger;
    protected final boolean useOriginalMessagePolicy;

    public RedeliveryErrorHandler(CamelContext camelContext, Processor output, Logger logger, Processor redeliveryProcessor, RedeliveryPolicy redeliveryPolicy, Predicate handledPolicy, Processor deadLetter, String deadLetterUri, boolean useOriginalMessagePolicy) {
        this.camelContext = camelContext;
        this.redeliveryProcessor = redeliveryProcessor;
        this.deadLetter = deadLetter;
        this.output = output;
        this.outputAsync = AsyncProcessorTypeConverter.convert(output);
        this.redeliveryPolicy = redeliveryPolicy;
        this.logger = logger;
        this.deadLetterUri = deadLetterUri;
        this.handledPolicy = handledPolicy;
        this.useOriginalMessagePolicy = useOriginalMessagePolicy;
    }

    public boolean supportTransacted() {
        return false;
    }

    public void process(Exchange exchange) throws Exception {
        if (this.output == null) {
            return;
        }
        AsyncProcessorHelper.process(this, exchange);
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        return this.processErrorHandler(exchange, callback, new RedeliveryData());
    }

    protected boolean processErrorHandler(final Exchange exchange, final AsyncCallback callback, final RedeliveryData data) {
        boolean done;
        do {
            boolean sync;
            boolean shouldRedeliver;
            if (!this.isRunAllowed()) {
                if (exchange.getException() == null) {
                    exchange.setException(new RejectedExecutionException());
                }
                callback.done(data.sync);
                return data.sync;
            }
            boolean handle = this.shouldHandleException(exchange);
            if (handle) {
                this.handleException(exchange, data);
            }
            if (!(shouldRedeliver = this.shouldRedeliver(exchange, data))) {
                Processor target = data.failureProcessor != null ? data.failureProcessor : data.deadLetterProcessor;
                boolean sync2 = this.deliverToFailureProcessor(target, exchange, data, callback);
                return sync2;
            }
            if (data.redeliveryCounter > 0) {
                data.redeliveryDelay = data.currentRedeliveryPolicy.calculateRedeliveryDelay(data.redeliveryDelay, data.redeliveryCounter);
                if (data.redeliveryDelay > 0L) {
                    if (data.currentRedeliveryPolicy.isAsyncDelayedRedelivery() && !exchange.isTransacted()) {
                        data.sync = false;
                        data.redeliverFromSync = true;
                        AsyncRedeliveryTask task = new AsyncRedeliveryTask(exchange, callback, data);
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("Scheduling redelivery task to run in " + data.redeliveryDelay + " millis for exchangeId: " + exchange.getExchangeId()));
                        }
                        executorService.schedule(task, data.redeliveryDelay, TimeUnit.MILLISECONDS);
                        return false;
                    }
                    try {
                        data.currentRedeliveryPolicy.sleep(data.redeliveryDelay);
                    }
                    catch (InterruptedException e) {
                        exchange.setException(e);
                        callback.done(data.sync);
                        return data.sync;
                    }
                }
                this.prepareExchangeForRedelivery(exchange);
                this.deliverToOnRedeliveryProcessor(exchange, data);
                EventHelper.notifyExchangeRedelivery(exchange.getContext(), exchange, data.redeliveryCounter);
            }
            if (sync = AsyncProcessorHelper.process(this.outputAsync, exchange, new AsyncCallback(){

                public void done(boolean sync) {
                    if (sync) {
                        return;
                    }
                    data.sync = false;
                    if (RedeliveryErrorHandler.this.isDone(exchange)) {
                        callback.done(sync);
                        return;
                    }
                    RedeliveryErrorHandler.this.processAsyncErrorHandler(exchange, callback, data);
                }
            })) continue;
            return false;
        } while (!(done = this.isDone(exchange)));
        callback.done(true);
        return true;
    }

    protected void processAsyncErrorHandler(Exchange exchange, AsyncCallback callback, RedeliveryData data) {
        boolean shouldRedeliver;
        if (!this.isRunAllowed()) {
            if (exchange.getException() == null) {
                exchange.setException(new RejectedExecutionException());
            }
            callback.done(data.sync);
            return;
        }
        boolean handle = this.shouldHandleException(exchange);
        if (handle) {
            this.handleException(exchange, data);
        }
        if (!(shouldRedeliver = this.shouldRedeliver(exchange, data))) {
            Processor target = data.failureProcessor != null ? data.failureProcessor : data.deadLetterProcessor;
            this.deliverToFailureProcessor(target, exchange, data, callback);
            return;
        }
        if (data.redeliveryCounter > 0) {
            AsyncRedeliveryTask task = new AsyncRedeliveryTask(exchange, callback, data);
            data.redeliveryDelay = data.currentRedeliveryPolicy.calculateRedeliveryDelay(data.redeliveryDelay, data.redeliveryCounter);
            if (data.redeliveryDelay > 0L) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Scheduling redelivery task to run in " + data.redeliveryDelay + " millis for exchangeId: " + exchange.getExchangeId()));
                }
                executorService.schedule(task, data.redeliveryDelay, TimeUnit.MILLISECONDS);
            } else {
                executorService.submit(task);
            }
        }
    }

    protected boolean shouldHandleException(Exchange exchange) {
        return exchange.getException() != null;
    }

    protected boolean isDone(Exchange exchange) {
        boolean answer;
        boolean bl = answer = exchange.getException() == null || ExchangeHelper.isFailureHandled(exchange) || ExchangeHelper.isRedeliveryExhausted(exchange);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Is exchangeId: " + exchange.getExchangeId() + " done? " + answer));
        }
        return answer;
    }

    public Processor getOutput() {
        return this.output;
    }

    public Processor getDeadLetter() {
        return this.deadLetter;
    }

    public String getDeadLetterUri() {
        return this.deadLetterUri;
    }

    public boolean isUseOriginalMessagePolicy() {
        return this.useOriginalMessagePolicy;
    }

    public RedeliveryPolicy getRedeliveryPolicy() {
        return this.redeliveryPolicy;
    }

    public Logger getLogger() {
        return this.logger;
    }

    protected void prepareExchangeForContinue(Exchange exchange, RedeliveryData data) {
        Exception caught = exchange.getException();
        this.prepareExchangeForRedelivery(exchange);
        exchange.getIn().removeHeader("CamelRedelivered");
        exchange.getIn().removeHeader("CamelRedeliveryCounter");
        String msg = "Failed delivery for exchangeId: " + exchange.getExchangeId();
        msg = msg + ". Exhausted after delivery attempt: " + data.redeliveryCounter + " caught: " + caught;
        msg = msg + ". Handled and continue routing.";
        this.logFailedDelivery(false, false, true, exchange, msg, data, null);
    }

    protected void prepareExchangeForRedelivery(Exchange exchange) {
        exchange.setException(null);
        exchange.setProperty("CamelRollbackOnly", null);
        MessageHelper.resetStreamCache(exchange.getIn());
    }

    protected void handleException(Exchange exchange, RedeliveryData data) {
        Exception e = exchange.getException();
        exchange.setProperty("CamelExceptionCaught", e);
        OnExceptionDefinition exceptionPolicy = this.getExceptionPolicy(exchange, e);
        if (exceptionPolicy != null) {
            data.currentRedeliveryPolicy = exceptionPolicy.createRedeliveryPolicy(exchange.getContext(), data.currentRedeliveryPolicy);
            data.handledPredicate = exceptionPolicy.getHandledPolicy();
            data.continuedPredicate = exceptionPolicy.getContinuedPolicy();
            data.retryWhilePredicate = exceptionPolicy.getRetryWhilePolicy();
            data.useOriginalInMessage = exceptionPolicy.getUseOriginalMessagePolicy();
            data.asyncDelayedRedelivery = exceptionPolicy.isAsyncDelayedRedelivery();
            Processor processor = exceptionPolicy.getErrorHandler();
            if (processor != null) {
                data.failureProcessor = processor;
            }
            if ((processor = exceptionPolicy.getOnRedelivery()) != null) {
                data.onRedeliveryProcessor = processor;
            }
        }
        String msg = "Failed delivery for exchangeId: " + exchange.getExchangeId() + ". On delivery attempt: " + data.redeliveryCounter + " caught: " + e;
        this.logFailedDelivery(true, false, false, exchange, msg, data, e);
        data.redeliveryCounter = this.incrementRedeliveryCounter(exchange, e);
    }

    protected void deliverToOnRedeliveryProcessor(Exchange exchange, RedeliveryData data) {
        if (data.onRedeliveryProcessor == null) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Redelivery processor " + data.onRedeliveryProcessor + " is processing Exchange: " + exchange + " before its redelivered"));
        }
        try {
            data.onRedeliveryProcessor.process(exchange);
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        this.log.trace((Object)"Redelivery processor done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean deliverToFailureProcessor(final Processor processor, final Exchange exchange, final RedeliveryData data, final AsyncCallback callback) {
        boolean sync = true;
        Exception caught = exchange.getException();
        exchange.setException(null);
        boolean handled = false;
        if (this.shouldHandled(exchange, data) || this.shouldContinue(exchange, data)) {
            exchange.getIn().removeHeader("CamelRedelivered");
            exchange.getIn().removeHeader("CamelRedeliveryCounter");
            handled = true;
        } else {
            this.decrementRedeliveryCounter(exchange);
        }
        if (processor != null) {
            MessageHelper.resetStreamCache(exchange.getIn());
            if (data.useOriginalInMessage) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"Using the original IN message instead of current");
                }
                Message original = exchange.getUnitOfWork().getOriginalInMessage();
                exchange.setIn(original);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Failure processor " + processor + " is processing Exchange: " + exchange));
            }
            exchange.setProperty("CamelFailureEndpoint", exchange.getProperty("CamelToEndpoint"));
            AsyncProcessor afp = AsyncProcessorTypeConverter.convert(processor);
            sync = AsyncProcessorHelper.process(afp, exchange, new AsyncCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void done(boolean sync) {
                    if (RedeliveryErrorHandler.this.log.isTraceEnabled()) {
                        RedeliveryErrorHandler.this.log.trace((Object)("Failure processor done: " + processor + " processing Exchange: " + exchange));
                    }
                    try {
                        RedeliveryErrorHandler.this.prepareExchangeAfterFailure(exchange, data);
                        boolean deadLetterChannel = processor == data.deadLetterProcessor && data.deadLetterProcessor != null;
                        EventHelper.notifyExchangeFailureHandled(exchange.getContext(), exchange, processor, deadLetterChannel);
                    }
                    finally {
                        data.sync &= sync;
                        callback.done(data.sync);
                    }
                }
            });
        } else {
            try {
                this.prepareExchangeAfterFailure(exchange, data);
            }
            finally {
                callback.done(data.sync);
            }
        }
        String msg = "Failed delivery for exchangeId: " + exchange.getExchangeId();
        msg = msg + ". Exhausted after delivery attempt: " + data.redeliveryCounter + " caught: " + caught;
        if (processor != null) {
            msg = msg + ". Processed by failure processor: " + processor;
        }
        this.logFailedDelivery(false, handled, false, exchange, msg, data, null);
        return sync;
    }

    protected void prepareExchangeAfterFailure(Exchange exchange, RedeliveryData data) {
        boolean alreadySet;
        ExchangeHelper.setFailureHandled(exchange);
        boolean bl = alreadySet = exchange.getProperty("CamelErrorHandlerHandled") != null;
        if (alreadySet) {
            boolean handled = exchange.getProperty("CamelErrorHandlerHandled", Boolean.class);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("This exchange has already been marked for handling: " + handled));
            }
            if (handled) {
                exchange.setException(null);
            } else {
                exchange.setException(exchange.getProperty("CamelExceptionCaught", Exception.class));
                exchange.setProperty("CamelFailureEndpoint", exchange.getProperty("CamelToEndpoint"));
            }
            return;
        }
        if (this.shouldHandled(exchange, data)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("This exchange is handled so its marked as not failed: " + exchange));
            }
            exchange.setProperty("CamelErrorHandlerHandled", Boolean.TRUE);
        } else if (this.shouldContinue(exchange, data)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("This exchange is continued: " + exchange));
            }
            this.prepareExchangeForContinue(exchange, data);
        } else {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("This exchange is not handled or continued so its marked as failed: " + exchange));
            }
            exchange.setProperty("CamelErrorHandlerHandled", Boolean.FALSE);
            exchange.setException(exchange.getProperty("CamelExceptionCaught", Exception.class));
            exchange.setProperty("CamelFailureEndpoint", exchange.getProperty("CamelToEndpoint"));
        }
    }

    private void logFailedDelivery(boolean shouldRedeliver, boolean handled, boolean continued, Exchange exchange, String message, RedeliveryData data, Throwable e) {
        boolean logStrackTrace;
        LoggingLevel newLogLevel;
        if (this.logger == null) {
            return;
        }
        if (handled && !data.currentRedeliveryPolicy.isLogHandled()) {
            return;
        }
        if (continued && !data.currentRedeliveryPolicy.isLogContinued()) {
            return;
        }
        if (shouldRedeliver && !data.currentRedeliveryPolicy.isLogRetryAttempted()) {
            return;
        }
        if (!shouldRedeliver && !data.currentRedeliveryPolicy.isLogExhausted()) {
            return;
        }
        if (shouldRedeliver) {
            newLogLevel = data.currentRedeliveryPolicy.getRetryAttemptedLogLevel();
            logStrackTrace = data.currentRedeliveryPolicy.isLogRetryStackTrace();
        } else {
            newLogLevel = data.currentRedeliveryPolicy.getRetriesExhaustedLogLevel();
            logStrackTrace = data.currentRedeliveryPolicy.isLogStackTrace();
        }
        if (e == null) {
            e = exchange.getProperty("CamelExceptionCaught", Exception.class);
        }
        if (exchange.isRollbackOnly()) {
            String msg = "Rollback exchange";
            if (exchange.getException() != null) {
                msg = msg + " due: " + exchange.getException().getMessage();
            }
            if (newLogLevel == LoggingLevel.ERROR || newLogLevel == LoggingLevel.FATAL) {
                this.logger.log(msg, LoggingLevel.WARN);
            } else {
                this.logger.log(msg, newLogLevel);
            }
        } else if (e != null && logStrackTrace) {
            this.logger.log(message, e, newLogLevel);
        } else {
            this.logger.log(message, newLogLevel);
        }
    }

    private boolean shouldRedeliver(Exchange exchange, RedeliveryData data) {
        boolean rollbackOnly = exchange.getProperty("CamelRollbackOnly", false, Boolean.class);
        if (rollbackOnly) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("This exchange is marked as rollback only, should not be redelivered: " + exchange));
            }
            return false;
        }
        return data.currentRedeliveryPolicy.shouldRedeliver(exchange, data.redeliveryCounter, data.retryWhilePredicate);
    }

    private boolean shouldContinue(Exchange exchange, RedeliveryData data) {
        if (data.continuedPredicate != null) {
            return data.continuedPredicate.matches(exchange);
        }
        return false;
    }

    private boolean shouldHandled(Exchange exchange, RedeliveryData data) {
        if (data.handledPredicate != null) {
            return data.handledPredicate.matches(exchange);
        }
        return false;
    }

    private int incrementRedeliveryCounter(Exchange exchange, Throwable e) {
        Message in = exchange.getIn();
        Integer counter = in.getHeader("CamelRedeliveryCounter", Integer.class);
        int next = 1;
        if (counter != null) {
            next = counter + 1;
        }
        in.setHeader("CamelRedeliveryCounter", next);
        in.setHeader("CamelRedelivered", Boolean.TRUE);
        return next;
    }

    private void decrementRedeliveryCounter(Exchange exchange) {
        Message in = exchange.getIn();
        Integer counter = in.getHeader("CamelRedeliveryCounter", Integer.class);
        if (counter != null) {
            int prev = counter - 1;
            in.setHeader("CamelRedeliveryCounter", prev);
            in.setHeader("CamelRedelivered", prev > 0 ? Boolean.TRUE : Boolean.FALSE);
        } else {
            in.setHeader("CamelRedeliveryCounter", 0);
            in.setHeader("CamelRedelivered", Boolean.FALSE);
        }
    }

    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.output, this.outputAsync, this.deadLetter);
        if (executorService == null || executorService.isShutdown()) {
            executorService = this.camelContext.getExecutorServiceStrategy().newScheduledThreadPool(this, "ErrorHandlerRedeliveryTask");
        }
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.deadLetter, this.output, this.outputAsync);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsyncRedeliveryTask
    implements Callable<Boolean> {
        private final Exchange exchange;
        private final AsyncCallback callback;
        private final RedeliveryData data;

        public AsyncRedeliveryTask(Exchange exchange, AsyncCallback callback, RedeliveryData data) {
            this.exchange = exchange;
            this.callback = callback;
            this.data = data;
        }

        @Override
        public Boolean call() throws Exception {
            RedeliveryErrorHandler.this.prepareExchangeForRedelivery(this.exchange);
            RedeliveryErrorHandler.this.deliverToOnRedeliveryProcessor(this.exchange, this.data);
            if (RedeliveryErrorHandler.this.log.isTraceEnabled()) {
                RedeliveryErrorHandler.this.log.trace((Object)("Redelivering exchangeId: " + this.exchange.getExchangeId() + " -> " + RedeliveryErrorHandler.this.outputAsync + " for Exchange: " + this.exchange));
            }
            EventHelper.notifyExchangeRedelivery(this.exchange.getContext(), this.exchange, this.data.redeliveryCounter);
            boolean sync = this.data.redeliverFromSync ? AsyncProcessorHelper.process(RedeliveryErrorHandler.this.outputAsync, this.exchange, new AsyncCallback(){

                public void done(boolean doneSync) {
                    if (RedeliveryErrorHandler.this.log.isTraceEnabled()) {
                        RedeliveryErrorHandler.this.log.trace((Object)("Redelivering exchangeId: " + AsyncRedeliveryTask.this.exchange.getExchangeId() + " done sync: " + doneSync));
                    }
                    ((AsyncRedeliveryTask)AsyncRedeliveryTask.this).data.sync = false;
                    if (RedeliveryErrorHandler.this.isDone(AsyncRedeliveryTask.this.exchange)) {
                        AsyncRedeliveryTask.this.callback.done(false);
                        return;
                    }
                    RedeliveryErrorHandler.this.processAsyncErrorHandler(AsyncRedeliveryTask.this.exchange, AsyncRedeliveryTask.this.callback, AsyncRedeliveryTask.this.data);
                }
            }) : AsyncProcessorHelper.process(RedeliveryErrorHandler.this.outputAsync, this.exchange, new AsyncCallback(){

                public void done(boolean doneSync) {
                    if (RedeliveryErrorHandler.this.log.isTraceEnabled()) {
                        RedeliveryErrorHandler.this.log.trace((Object)("Redelivering exchangeId: " + AsyncRedeliveryTask.this.exchange.getExchangeId() + " done sync: " + doneSync));
                    }
                    if (doneSync) {
                        return;
                    }
                    ((AsyncRedeliveryTask)AsyncRedeliveryTask.this).data.sync = false;
                    if (RedeliveryErrorHandler.this.isDone(AsyncRedeliveryTask.this.exchange)) {
                        AsyncRedeliveryTask.this.callback.done(doneSync);
                        return;
                    }
                    RedeliveryErrorHandler.this.processAsyncErrorHandler(AsyncRedeliveryTask.this.exchange, AsyncRedeliveryTask.this.callback, AsyncRedeliveryTask.this.data);
                }
            });
            return sync;
        }
    }

    protected class RedeliveryData {
        boolean sync = true;
        int redeliveryCounter;
        long redeliveryDelay;
        Predicate retryWhilePredicate;
        boolean redeliverFromSync;
        RedeliveryPolicy currentRedeliveryPolicy;
        Processor deadLetterProcessor;
        Processor failureProcessor;
        Processor onRedeliveryProcessor;
        Predicate handledPredicate;
        Predicate continuedPredicate;
        boolean useOriginalInMessage;
        boolean asyncDelayedRedelivery;

        protected RedeliveryData() {
            this.currentRedeliveryPolicy = RedeliveryErrorHandler.this.redeliveryPolicy;
            this.deadLetterProcessor = RedeliveryErrorHandler.this.deadLetter;
            this.onRedeliveryProcessor = RedeliveryErrorHandler.this.redeliveryProcessor;
            this.handledPredicate = RedeliveryErrorHandler.this.handledPolicy;
            this.useOriginalInMessage = RedeliveryErrorHandler.this.useOriginalMessagePolicy;
            this.asyncDelayedRedelivery = RedeliveryErrorHandler.this.redeliveryPolicy.isAsyncDelayedRedelivery();
        }
    }
}

