/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxb;

import org.apache.camel.converter.jaxb.FilteringXmlStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class NonXmlCharFilterer {
    private static final transient Log LOG = LogFactory.getLog(FilteringXmlStreamWriter.class);
    private static final char REPLACEMENT_CHAR = ' ';

    NonXmlCharFilterer() {
    }

    boolean isFiltered(char c) {
        return c != '\t' && c != '\n' && c != '\r' && (c < ' ' || c > '\ud7ff') && (c < '\ue000' || c > '\ufffd');
    }

    public boolean filter(char[] content, int offset, int length) {
        if (content == null) {
            return false;
        }
        boolean filtered = false;
        for (int i = offset; i < offset + length; ++i) {
            if (!this.isFiltered(content[i])) continue;
            filtered = true;
            content[i] = 32;
        }
        if (filtered) {
            LOG.warn((Object)"Identified and replaced non-XML chars");
        }
        return filtered;
    }

    public String filter(String original) {
        if (original == null) {
            return null;
        }
        char[] chars = original.toCharArray();
        if (!this.filter(chars, 0, chars.length)) {
            return original;
        }
        String filtered = new String(chars);
        LOG.warn((Object)("Illegal characters were filtered; original => \"" + original + "\", filtered => \"" + filtered + "\""));
        return filtered;
    }
}

