/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterImpl
implements Cluster {
    final CopyOnWriteArraySet<MembershipListener> listeners = new CopyOnWriteArraySet();
    final AtomicReference<Set<Member>> members = new AtomicReference();
    final AtomicReference<Member> localMember = new AtomicReference();
    final Map<Member, Member> clusterMembers = new ConcurrentHashMap<Member, Member>();
    final Map<Member, Integer> distances = new ConcurrentHashMap<Member, Integer>();
    volatile long clusterTimeDiff = Long.MAX_VALUE;
    final Node node;

    public ClusterImpl(Node node, MemberImpl thisMember) {
        this.node = node;
        this.setMembers(Arrays.asList(thisMember));
    }

    public int getDistanceFrom(Member member) {
        if (member.localMember()) {
            return 0;
        }
        Integer distance = this.distances.get(member);
        if (distance != null) {
            return distance;
        }
        Set<Member> currentMembers = this.members.get();
        int size = currentMembers.size();
        Member localMember = this.getLocalMember();
        int index = 0;
        int toIndex = this.getIndexOf(localMember, currentMembers);
        for (Member m : currentMembers) {
            if (!m.equals(localMember)) {
                distance = (toIndex - index + size) % size;
                this.distances.put(m, distance);
            }
            ++index;
        }
        Integer d = this.distances.get(member);
        return d == null ? -1 : d;
    }

    private int getIndexOf(Member member, Set<Member> memberSet) {
        int count = 0;
        for (Member m : memberSet) {
            if (m.equals(member)) {
                return count;
            }
            ++count;
        }
        return count;
    }

    public void setMembers(List<MemberImpl> lsMembers) {
        LinkedHashSet<Member> setNew = new LinkedHashSet<Member>(lsMembers.size());
        ArrayList<Runnable> notifications = new ArrayList<Runnable>();
        for (MemberImpl memberImpl : lsMembers) {
            final MemberImpl dummy = new MemberImpl(memberImpl.getAddress(), memberImpl.localMember(), memberImpl.getNodeType());
            Member clusterMember = this.clusterMembers.get(dummy);
            if (clusterMember == null) {
                clusterMember = dummy;
                if (this.listeners.size() > 0) {
                    notifications.add(new Runnable(){

                        public void run() {
                            MembershipEvent membershipEvent = new MembershipEvent(ClusterImpl.this, dummy, 1);
                            for (MembershipListener listener : ClusterImpl.this.listeners) {
                                listener.memberAdded(membershipEvent);
                            }
                        }
                    });
                }
            }
            if (clusterMember.localMember()) {
                this.localMember.set(clusterMember);
            }
            setNew.add(clusterMember);
        }
        if (this.listeners.size() > 0) {
            Set<Member> it = this.clusterMembers.keySet();
            for (final Member member : it) {
                if (setNew.contains(member)) continue;
                notifications.add(new Runnable(){

                    public void run() {
                        MembershipEvent membershipEvent = new MembershipEvent(ClusterImpl.this, member, 3);
                        for (MembershipListener listener : ClusterImpl.this.listeners) {
                            listener.memberRemoved(membershipEvent);
                        }
                    }
                });
            }
        }
        this.clusterMembers.clear();
        for (Member member : setNew) {
            this.clusterMembers.put(member, member);
        }
        this.members.set(setNew);
        this.distances.clear();
        for (Runnable runnable : notifications) {
            this.node.executorManager.getEventExecutorService().execute(runnable);
        }
    }

    @Override
    public void addMembershipListener(MembershipListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeMembershipListener(MembershipListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Member getLocalMember() {
        return this.localMember.get();
    }

    @Override
    public Set<Member> getMembers() {
        return this.members.get();
    }

    public String toString() {
        Set<Member> members = this.getMembers();
        StringBuffer sb = new StringBuffer("Cluster [");
        if (members != null) {
            sb.append(members.size());
            sb.append("] {");
            for (Member member : members) {
                sb.append("\n\t").append(member);
            }
        }
        sb.append("\n}\n");
        return sb.toString();
    }

    @Override
    public long getClusterTime() {
        return System.currentTimeMillis() + (this.clusterTimeDiff == Long.MAX_VALUE ? 0L : this.clusterTimeDiff);
    }

    public void setMasterTime(long masterTime) {
        long diff = masterTime - System.currentTimeMillis();
        if (Math.abs(diff) < Math.abs(this.clusterTimeDiff)) {
            this.clusterTimeDiff = diff;
        }
    }

    public long getClusterTimeFor(long localTime) {
        return localTime + (this.clusterTimeDiff == Long.MAX_VALUE ? 0L : this.clusterTimeDiff);
    }
}

