/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.impl.NodeType;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MemberInfo
implements DataSerializable {
    Address address = null;
    NodeType nodeType = NodeType.MEMBER;

    public MemberInfo() {
    }

    public MemberInfo(Address address) {
        this.address = address;
    }

    public MemberInfo(Address address, NodeType nodeType) {
        this.address = address;
        this.nodeType = nodeType;
    }

    public void readData(DataInput in) throws IOException {
        this.address = new Address();
        this.address.readData(in);
        this.nodeType = NodeType.create(in.readInt());
    }

    public void writeData(DataOutput out) throws IOException {
        this.address.writeData(out);
        out.writeInt(this.nodeType.getValue());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemberInfo other = (MemberInfo)obj;
        return !(this.address == null ? other.address != null : !this.address.equals(other.address));
    }
}

