/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

public final class QueueConfig {
    public static final int DEFAULT_MAX_SIZE_PER_JVM = Integer.MAX_VALUE;
    public static final int DEFAULT_TTL_SECONDS = Integer.MAX_VALUE;
    private String name;
    private int maxSizePerJVM = Integer.MAX_VALUE;
    private int timeToLiveSeconds = Integer.MAX_VALUE;

    public String getName() {
        return this.name;
    }

    public QueueConfig setName(String name) {
        this.name = name;
        return this;
    }

    public int getMaxSizePerJVM() {
        return this.maxSizePerJVM;
    }

    public QueueConfig setMaxSizePerJVM(int maxSizePerJVM) {
        if (maxSizePerJVM < 0) {
            throw new IllegalArgumentException("queue max size per JVM must be positive");
        }
        this.maxSizePerJVM = maxSizePerJVM;
        return this;
    }

    public int getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public QueueConfig setTimeToLiveSeconds(int timeToLiveSeconds) {
        if (timeToLiveSeconds < 0) {
            throw new IllegalArgumentException("queue TTL must be positive");
        }
        this.timeToLiveSeconds = timeToLiveSeconds;
        return this;
    }
}

