/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.monitor.LocalMapOperationStats;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MapOperationStatsImpl
implements DataSerializable,
LocalMapOperationStats {
    long periodStart;
    long periodEnd;
    long numberOfPuts;
    long numberOfGets;
    long numberOfRemoves;
    long numberOfOtherOperations;
    long numberOfEvents;

    public void writeData(DataOutput out) throws IOException {
        out.writeLong(this.numberOfPuts);
        out.writeLong(this.numberOfGets);
        out.writeLong(this.numberOfRemoves);
        out.writeLong(this.numberOfOtherOperations);
        out.writeLong(this.numberOfEvents);
        out.writeLong(this.periodStart);
        out.writeLong(this.periodEnd);
    }

    public void readData(DataInput in) throws IOException {
        this.numberOfPuts = in.readLong();
        this.numberOfGets = in.readLong();
        this.numberOfRemoves = in.readLong();
        this.numberOfOtherOperations = in.readLong();
        this.numberOfEvents = in.readLong();
        this.periodStart = in.readLong();
        this.periodEnd = in.readLong();
    }

    public long total() {
        return this.numberOfPuts + this.numberOfGets + this.numberOfRemoves + this.numberOfOtherOperations;
    }

    public long getPeriodStart() {
        return this.periodStart;
    }

    public long getPeriodEnd() {
        return this.periodEnd;
    }

    public long getNumberOfPuts() {
        return this.numberOfPuts;
    }

    public long getNumberOfGets() {
        return this.numberOfGets;
    }

    public long getNumberOfRemoves() {
        return this.numberOfRemoves;
    }

    public long getNumberOfOtherOperations() {
        return this.numberOfOtherOperations;
    }

    public long getNumberOfEvents() {
        return this.numberOfEvents;
    }

    public String toString() {
        return "LocalMapOperationStats{total= " + this.total() + ", puts:" + this.numberOfPuts + ", gets:" + this.numberOfGets + ", removes:" + this.numberOfRemoves + ", others: " + this.numberOfOtherOperations + ", received events: " + this.numberOfEvents + "}";
    }
}

