/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.Member;
import com.hazelcast.impl.Block;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.Processable;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.partition.MigrationEvent;
import com.hazelcast.partition.MigrationListener;
import com.hazelcast.partition.Partition;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.util.ResponseQueueFactory;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartitionServiceImpl
implements PartitionService {
    private final ConcurrentMap<Integer, PartitionReal> mapRealPartitions = new ConcurrentHashMap<Integer, PartitionReal>();
    private final ConcurrentMap<Integer, PartitionProxy> mapPartitions = new ConcurrentHashMap<Integer, PartitionProxy>();
    private final List<MigrationListener> lsMigrationListeners = new CopyOnWriteArrayList<MigrationListener>();
    private final ConcurrentMapManager concurrentMapManager;
    private final AtomicLong partitionVersion = new AtomicLong();

    public PartitionServiceImpl(ConcurrentMapManager concurrentMapManager) {
        this.concurrentMapManager = concurrentMapManager;
    }

    @Override
    public Set<Partition> getPartitions() {
        TreeSet<Partition> partitions = new TreeSet<Partition>(this.mapPartitions.values());
        for (int i = 0; i < this.concurrentMapManager.PARTITION_COUNT; ++i) {
            partitions.add(this.getPartition(i));
        }
        return partitions;
    }

    public boolean isMigrating() {
        Set<Partition> partitions = this.getPartitions();
        for (Partition partition : partitions) {
            if (!((PartitionProxy)partition).isMigrating()) continue;
            return true;
        }
        return false;
    }

    @Override
    public PartitionProxy getPartition(Object key) {
        Data keyData = IOUtil.toData(key);
        int partitionId = this.concurrentMapManager.getBlockId(keyData);
        return this.getPartition(partitionId);
    }

    public PartitionProxy getPartition(final int partitionId) {
        PartitionProxy partition = (PartitionProxy)this.mapPartitions.get(partitionId);
        if (partition != null && partition.getOwner() != null) {
            return partition;
        }
        final BlockingQueue responseQ = ResponseQueueFactory.newResponseQueue();
        this.concurrentMapManager.enqueueAndReturn(new Processable(){

            public void process() {
                Block block = ((PartitionServiceImpl)PartitionServiceImpl.this).concurrentMapManager.blocks[partitionId];
                if (block == null) {
                    block = PartitionServiceImpl.this.concurrentMapManager.getOrCreateBlock(partitionId);
                }
                MemberImpl memberOwner = null;
                if (block.getOwner() != null) {
                    memberOwner = ((PartitionServiceImpl)PartitionServiceImpl.this).concurrentMapManager.thisAddress.equals(block.getOwner()) ? ((PartitionServiceImpl)PartitionServiceImpl.this).concurrentMapManager.thisMember : PartitionServiceImpl.this.concurrentMapManager.getMember(block.getOwner());
                }
                responseQ.offer(new PartitionReal(partitionId, memberOwner, null));
            }
        });
        partition = new PartitionProxy(partitionId);
        try {
            PartitionReal partitionReal = (PartitionReal)responseQ.take();
            this.mapRealPartitions.put(partitionId, partitionReal);
            PartitionProxy oldPartitionProxy = this.mapPartitions.putIfAbsent(partitionId, partition);
            if (oldPartitionProxy != null) {
                return oldPartitionProxy;
            }
        }
        catch (InterruptedException ignored) {
            // empty catch block
        }
        return partition;
    }

    void doFireMigrationEvent(final boolean started, final MigrationEvent migrationEvent) {
        this.partitionVersion.incrementAndGet();
        if (migrationEvent == null) {
            throw new RuntimeException("MigrationEvent: " + migrationEvent);
        }
        Member owner = started ? migrationEvent.getOldOwner() : migrationEvent.getNewOwner();
        Member migrationMember = started ? migrationEvent.getNewOwner() : null;
        PartitionReal partitionReal = new PartitionReal(migrationEvent.getPartitionId(), owner, migrationMember);
        this.mapRealPartitions.put(partitionReal.getPartitionId(), partitionReal);
        for (final MigrationListener migrationListener : this.lsMigrationListeners) {
            this.concurrentMapManager.executeLocally(new Runnable(){

                public void run() {
                    if (started) {
                        migrationListener.migrationStarted(migrationEvent);
                    } else {
                        migrationListener.migrationCompleted(migrationEvent);
                    }
                }
            });
        }
    }

    @Override
    public void addMigrationListener(MigrationListener migrationListener) {
        this.lsMigrationListeners.add(migrationListener);
    }

    @Override
    public void removeMigrationListener(MigrationListener migrationListener) {
        this.lsMigrationListeners.remove(migrationListener);
    }

    public void reset() {
        this.mapPartitions.clear();
    }

    class PartitionReal
    implements Partition,
    Comparable {
        final int partitionId;
        final Member owner;
        final Member migrationMember;

        PartitionReal(int partitionId, Member owner, Member migrationMember) {
            this.partitionId = partitionId;
            this.owner = owner;
            this.migrationMember = migrationMember;
        }

        public int getPartitionId() {
            return this.partitionId;
        }

        public Member getOwner() {
            return this.owner;
        }

        public Member getMigrationMember() {
            return this.migrationMember;
        }

        public Member getEventualOwner() {
            return this.migrationMember != null ? this.migrationMember : this.owner;
        }

        public boolean isMigrating() {
            return this.migrationMember != null;
        }

        public int compareTo(Object o) {
            PartitionReal partition = (PartitionReal)o;
            Integer id = this.partitionId;
            return id.compareTo(partition.getPartitionId());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionReal partition = (PartitionReal)o;
            return this.partitionId == partition.partitionId;
        }

        public int hashCode() {
            return this.partitionId;
        }

        public String toString() {
            return "PartitionReal [" + this.partitionId + "], owner=" + this.getOwner() + ", migrationMember=" + this.migrationMember;
        }
    }

    class PartitionProxy
    implements Partition,
    Comparable {
        final int partitionId;

        PartitionProxy(int partitionId) {
            this.partitionId = partitionId;
        }

        public int getPartitionId() {
            return this.partitionId;
        }

        public Member getOwner() {
            PartitionReal partitionReal = (PartitionReal)PartitionServiceImpl.this.mapRealPartitions.get(this.partitionId);
            if (partitionReal == null) {
                return null;
            }
            return partitionReal.getOwner();
        }

        public boolean isMigrating() {
            PartitionReal partitionReal = (PartitionReal)PartitionServiceImpl.this.mapRealPartitions.get(this.partitionId);
            return partitionReal != null && partitionReal.isMigrating();
        }

        public Member getEventualOwner() {
            PartitionReal partitionReal = (PartitionReal)PartitionServiceImpl.this.mapRealPartitions.get(this.partitionId);
            if (partitionReal == null) {
                return null;
            }
            return partitionReal.getEventualOwner();
        }

        public Member getMigrationMember() {
            PartitionReal partitionReal = (PartitionReal)PartitionServiceImpl.this.mapRealPartitions.get(this.partitionId);
            if (partitionReal == null) {
                return null;
            }
            return partitionReal.getMigrationMember();
        }

        public int compareTo(Object o) {
            PartitionProxy partition = (PartitionProxy)o;
            Integer id = this.partitionId;
            return id.compareTo(partition.getPartitionId());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionProxy partition = (PartitionProxy)o;
            return this.partitionId == partition.partitionId;
        }

        public int hashCode() {
            return this.partitionId;
        }

        public String toString() {
            return "Partition [" + this.partitionId + "], owner=" + this.getOwner();
        }
    }
}

