/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.MapEntry;
import com.hazelcast.impl.MProxy;
import com.hazelcast.impl.Record;
import com.hazelcast.nio.IOUtil;

public class RecordEntry
implements MapEntry {
    final Record record;
    private volatile Object keyObject;
    private volatile Object valueObject;

    public RecordEntry(Record record) {
        this.record = record;
    }

    public boolean isValid() {
        return this.record.isActive();
    }

    public Object getKey() {
        if (this.keyObject == null) {
            this.keyObject = IOUtil.toObject(this.record.getKey());
        }
        return this.keyObject;
    }

    public Object getValue() {
        if (this.valueObject == null) {
            this.valueObject = IOUtil.toObject(this.record.getValue());
        }
        return this.valueObject;
    }

    public Object setValue(Object value) {
        MProxy proxy = (MProxy)this.record.getCMap().concurrentMapManager.node.factory.getOrCreateProxyByName(this.record.getName());
        Object oldValue = proxy.put(this.getKey(), value);
        this.valueObject = value;
        return oldValue;
    }

    public long getCost() {
        return this.record.getCost();
    }

    public long getExpirationTime() {
        return this.record.getExpirationTime();
    }

    public long getVersion() {
        return this.record.getVersion();
    }

    public long getCreationTime() {
        return this.record.getCreationTime();
    }

    public long getLastAccessTime() {
        return this.record.getLastAccessTime();
    }

    public long getLastUpdateTime() {
        return this.record.getLastUpdateTime();
    }

    public int getHits() {
        return this.record.getHits();
    }
}

