/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.cluster.AddOrRemoveConnection;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.nio.ReadHandler;
import com.hazelcast.nio.WriteHandler;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;

public class Connection {
    final SocketChannel socketChannel;
    final ReadHandler readHandler;
    final WriteHandler writeHandler;
    final ConnectionManager connectionManager;
    private volatile boolean live = true;
    private volatile Type type = Type.NONE;
    Address endPoint = null;
    private final ILogger logger;
    private final int connectionId;

    public Connection(ConnectionManager connectionManager, int connectionId, SocketChannel socketChannel) {
        this.connectionId = connectionId;
        this.logger = connectionManager.node.getLogger(Connection.class.getName());
        this.connectionManager = connectionManager;
        this.socketChannel = socketChannel;
        this.writeHandler = new WriteHandler(this);
        this.readHandler = new ReadHandler(this);
    }

    public Type getType() {
        return this.type;
    }

    public boolean isClient() {
        return this.type != null && this.type != Type.NONE && this.type.isClient();
    }

    public void setType(Type type) {
        if (this.type == Type.NONE) {
            this.type = type;
        }
    }

    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    public ReadHandler getReadHandler() {
        return this.readHandler;
    }

    public WriteHandler getWriteHandler() {
        return this.writeHandler;
    }

    public void setLive(boolean live) {
        this.live = live;
    }

    public boolean live() {
        return this.live;
    }

    public Address getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(Address endPoint) {
        this.endPoint = endPoint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Connection that = (Connection)o;
        return this.connectionId == that.connectionId;
    }

    public int hashCode() {
        return this.connectionId;
    }

    public void close() {
        if (!this.live) {
            return;
        }
        this.live = false;
        try {
            if (this.socketChannel != null && this.socketChannel.isOpen()) {
                this.socketChannel.close();
            }
            this.readHandler.shutdown();
            this.writeHandler.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logger.log(Level.FINE, "Connection lost " + this.endPoint);
        this.connectionManager.remove(this);
        AddOrRemoveConnection addOrRemoveConnection = new AddOrRemoveConnection(this.endPoint, false);
        addOrRemoveConnection.setNode(this.connectionManager.node);
        this.connectionManager.node.clusterManager.enqueueAndReturn(addOrRemoveConnection);
    }

    public String toString() {
        return "Connection [" + this.endPoint + "] live=" + this.live;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NONE(false, false),
        MEMBER(true, true),
        JAVA_CLIENT(false, true),
        REST_CLIENT(false, false),
        MEMCACHE_CLIENT(false, false);

        final boolean member;
        final boolean binary;

        private Type(boolean member, boolean binary) {
            this.member = member;
            this.binary = binary;
        }

        public boolean isBinary() {
            return this.binary;
        }

        public boolean isClient() {
            return !this.member;
        }
    }
}

