/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public final class Data
implements DataSerializable {
    public byte[] buffer = null;

    public Data() {
    }

    public Data(byte[] bytes) {
        this.buffer = bytes;
    }

    public int size() {
        return this.buffer == null ? 0 : this.buffer.length;
    }

    public void readData(DataInput in) throws IOException {
        int size = in.readInt();
        if (size > 0) {
            this.buffer = new byte[size];
            in.readFully(this.buffer);
        }
    }

    public void writeData(DataOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.size() > 0) {
            out.write(this.buffer);
        }
    }

    public int hashCode() {
        if (this.buffer == null) {
            return Integer.MIN_VALUE;
        }
        int h = 1;
        for (int i = 0; i < this.size(); ++i) {
            h = 31 * h + this.buffer[i];
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Data)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Data data = (Data)obj;
        if (this.size() != data.size()) {
            return false;
        }
        if (this.size() == 0) {
            return data.buffer == null;
        }
        return Arrays.equals(this.buffer, data.buffer);
    }

    public String toString() {
        return "Data size = " + this.size();
    }
}

