/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NoneStrictObjectPool<T> {
    private final ConcurrentLinkedQueue<T> queue = new ConcurrentLinkedQueue();
    private final AtomicInteger size = new AtomicInteger();
    private final int maxSize;

    public NoneStrictObjectPool(int maxSize) {
        this.maxSize = maxSize;
    }

    public boolean release(T t) {
        this.onRelease(t);
        if (this.size.get() < this.maxSize) {
            this.queue.offer(t);
            return true;
        }
        return false;
    }

    public T obtain() {
        T t = this.queue.poll();
        if (t == null) {
            t = this.createNew();
        } else {
            this.size.decrementAndGet();
            this.onObtain(t);
        }
        return t;
    }

    public abstract T createNew();

    public abstract void onRelease(T var1);

    public abstract void onObtain(T var1);

    public void clear() {
        this.queue.clear();
    }
}

