/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.impl;

import org.drools.grid.ConnectionFactoryService;
import org.drools.grid.Grid;
import org.drools.grid.GridConnection;
import org.drools.grid.GridNode;
import org.drools.grid.GridServiceDescription;
import org.drools.grid.local.LocalGridNodeConnection;
import org.drools.grid.remote.RemoteGridNodeConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionFactoryServiceImpl
implements ConnectionFactoryService {
    Grid grid;
    boolean localAllowed;

    public ConnectionFactoryServiceImpl(Grid grid) {
        this.grid = grid;
        this.localAllowed = true;
    }

    @Override
    public <T> GridConnection<T> createConnection(GridServiceDescription<T> gsd) {
        GridNode gnode;
        GridConnection<GridNode> conn = null;
        if (this.localAllowed && (gnode = this.grid.getGridNode(gsd.getId())) != null) {
            conn = new LocalGridNodeConnection(gnode);
        }
        if (conn == null) {
            conn = new RemoteGridNodeConnection(this.grid, gsd);
        }
        return conn;
    }

    public boolean isLocalAllowed() {
        return this.localAllowed;
    }

    public void setLocalAllowed(boolean localAllowed) {
        this.localAllowed = localAllowed;
    }
}

