/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.remote;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Iterator;
import org.drools.command.Command;
import org.drools.command.KnowledgeContextResolveFromContextCommand;
import org.drools.grid.GridNode;
import org.drools.grid.GridServiceDescription;
import org.drools.grid.io.ConversationManager;
import org.drools.grid.io.impl.CommandImpl;
import org.drools.grid.remote.ConversationUtil;
import org.drools.grid.remote.QueryResultsRowIteratorRemoteClient;
import org.drools.grid.remote.command.GetQueryIdentifiersRemoteCommand;
import org.drools.grid.remote.command.GetQueryResultsSizeRemoteCommand;
import org.drools.grid.remote.command.SetQueryIteratorRemoteCommand;
import org.drools.runtime.rule.QueryResults;
import org.drools.runtime.rule.QueryResultsRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryResultsRemoteClient
implements QueryResults {
    private String localId;
    private GridServiceDescription<GridNode> gsd;
    private ConversationManager cm;
    private String instanceId;
    private String queryName;

    public QueryResultsRemoteClient(String queryName, String instanceId, String localId, GridServiceDescription gsd, ConversationManager cm) {
        this.queryName = queryName;
        this.instanceId = instanceId;
        this.localId = localId;
        this.gsd = gsd;
        this.cm = cm;
    }

    public String[] getIdentifiers() {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new GetQueryIdentifiersRemoteCommand(this.queryName, this.localId), null, null, this.instanceId, kresultsId)));
        String[] results = (String[])ConversationUtil.sendMessage(this.cm, (InetSocketAddress)this.gsd.getAddresses().get("socket").getObject(), this.gsd.getId(), cmd);
        return results;
    }

    public Iterator<QueryResultsRow> iterator() {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new SetQueryIteratorRemoteCommand(this.queryName, this.localId), null, null, this.instanceId, kresultsId)));
        ConversationUtil.sendMessage(this.cm, (InetSocketAddress)this.gsd.getAddresses().get("socket").getObject(), this.gsd.getId(), cmd);
        return new QueryResultsRowIteratorRemoteClient(this.queryName, this.localId, this.instanceId, this.gsd, this.cm);
    }

    public int size() {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new GetQueryResultsSizeRemoteCommand(this.queryName, this.localId), null, null, this.instanceId, kresultsId)));
        Integer result = (Integer)ConversationUtil.sendMessage(this.cm, (InetSocketAddress)this.gsd.getAddresses().get("socket").getObject(), this.gsd.getId(), cmd);
        return result;
    }
}

