/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.remote;

import java.net.InetSocketAddress;
import java.util.Arrays;
import org.drools.command.Command;
import org.drools.command.KnowledgeContextResolveFromContextCommand;
import org.drools.grid.GridNode;
import org.drools.grid.GridServiceDescription;
import org.drools.grid.io.ConversationManager;
import org.drools.grid.io.impl.CommandImpl;
import org.drools.grid.remote.ConversationUtil;
import org.drools.grid.remote.command.GetFactHandleFromQueryResultsRowRemoteCommand;
import org.drools.grid.remote.command.GetObjectFromQueryResultsRowRemoteCommand;
import org.drools.runtime.rule.FactHandle;
import org.drools.runtime.rule.QueryResultsRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryResultsRowRemoteClient
implements QueryResultsRow {
    private String queryName;
    private String localId;
    private String instanceId;
    private GridServiceDescription<GridNode> gsd;
    private ConversationManager cm;
    private String rowId;

    public QueryResultsRowRemoteClient(String rowId, String queryName, String localId, String instanceId, GridServiceDescription<GridNode> gsd, ConversationManager cm) {
        this.queryName = queryName;
        this.localId = localId;
        this.instanceId = instanceId;
        this.gsd = gsd;
        this.cm = cm;
        this.rowId = rowId;
    }

    public Object get(String identifier) {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new GetObjectFromQueryResultsRowRemoteCommand(this.rowId, this.queryName, this.localId, identifier), null, null, this.instanceId, kresultsId)));
        Object result = ConversationUtil.sendMessage(this.cm, (InetSocketAddress)this.gsd.getAddresses().get("socket").getObject(), this.gsd.getId(), cmd);
        return result;
    }

    public FactHandle getFactHandle(String identifier) {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new GetFactHandleFromQueryResultsRowRemoteCommand(this.rowId, this.queryName, this.localId, identifier), null, null, this.instanceId, kresultsId)));
        FactHandle result = (FactHandle)ConversationUtil.sendMessage(this.cm, (InetSocketAddress)this.gsd.getAddresses().get("socket").getObject(), this.gsd.getId(), cmd);
        return result;
    }
}

