/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.service.directory.impl;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.drools.grid.GridServiceDescription;
import org.drools.grid.service.directory.Address;
import org.drools.grid.service.directory.impl.AddressJpa;
import org.drools.grid.service.directory.impl.GridServiceDescriptionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridServiceDescriptionJpa<T>
implements GridServiceDescription,
Serializable {
    private GridServiceDescription<T> detached;
    private transient EntityManagerFactory emf;

    public GridServiceDescriptionJpa(GridServiceDescription detached, EntityManagerFactory emf) {
        this.detached = detached;
        this.emf = emf;
    }

    @Override
    public Map<String, Address> getAddresses() {
        EntityManager em = this.emf.createEntityManager();
        HashMap<String, AddressJpa> addresses = new HashMap<String, AddressJpa>();
        for (Address address : this.detached.getAddresses().values()) {
            addresses.put(address.getTransport(), new AddressJpa(address, this.emf));
        }
        em.close();
        return Collections.unmodifiableMap(addresses);
    }

    @Override
    public Address addAddress(String transport) {
        EntityManager em = this.emf.createEntityManager();
        em.getTransaction().begin();
        this.detached = (GridServiceDescription)em.find(GridServiceDescriptionImpl.class, (Object)this.detached.getId());
        Address address = this.detached.addAddress(transport);
        em.getTransaction().commit();
        em.close();
        return new AddressJpa(address, this.emf);
    }

    @Override
    public void removeAddress(String transport) {
        EntityManager em = this.emf.createEntityManager();
        em.getTransaction().begin();
        this.detached = (GridServiceDescription)em.find(GridServiceDescriptionImpl.class, (Object)this.detached.getId());
        Address address = this.detached.getAddresses().get(transport);
        this.detached.removeAddress(transport);
        em.remove((Object)address);
        em.getTransaction().commit();
        em.close();
    }

    @Override
    public String getId() {
        return this.detached.getId();
    }

    public Class getServiceInterface() {
        return this.detached.getServiceInterface();
    }

    public void setServiceInterface(Class cls) {
        EntityManager em = this.emf.createEntityManager();
        em.getTransaction().begin();
        this.detached = (GridServiceDescription)em.find(GridServiceDescriptionImpl.class, (Object)this.detached.getId());
        this.detached.setServiceInterface(cls);
        em.getTransaction().commit();
        em.close();
    }

    private Object readResolve() throws ObjectStreamException {
        return this.detached;
    }

    @Override
    public Serializable getData() {
        EntityManager em = this.emf.createEntityManager();
        em.getTransaction().begin();
        this.detached = (GridServiceDescription)em.find(GridServiceDescriptionImpl.class, (Object)this.detached.getId());
        Serializable data = this.detached.getData();
        em.getTransaction().commit();
        em.close();
        return data;
    }

    public boolean equals(Object obj) {
        GridServiceDescription other = (GridServiceDescription)obj;
        return this.getId().equals(other.getId());
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.detached != null ? this.detached.hashCode() : 0);
        return hash;
    }

    @Override
    public void setData(Serializable data) {
        EntityManager em = this.emf.createEntityManager();
        em.getTransaction().begin();
        this.detached = (GridServiceDescription)em.find(GridServiceDescriptionImpl.class, (Object)this.detached.getId());
        this.detached.setData(data);
        em.getTransaction().commit();
        em.close();
    }
}

