/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.service.directory.impl;

import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.grid.CoreServicesLookup;
import org.drools.grid.Grid;
import org.drools.grid.GridServiceDescription;
import org.drools.grid.MessageReceiverHandlerFactoryService;
import org.drools.grid.io.MessageReceiverHandler;
import org.drools.grid.service.directory.Address;
import org.drools.grid.service.directory.WhitePages;
import org.drools.grid.service.directory.impl.CoreServicesLookupImpl;
import org.drools.grid.service.directory.impl.GridServiceDescriptionImpl;
import org.drools.grid.service.directory.impl.WhitePagesServer;
import org.drools.grid.service.directory.impl.WhitePagesServiceConfiguration;

public class WhitePagesImpl
implements WhitePages,
MessageReceiverHandlerFactoryService {
    private Map<String, GridServiceDescription> directory = new ConcurrentHashMap<String, GridServiceDescription>();

    public GridServiceDescription create(String serviceDescriptionId) {
        GridServiceDescriptionImpl gsd = new GridServiceDescriptionImpl(serviceDescriptionId);
        this.directory.put(gsd.getId(), gsd);
        return gsd;
    }

    public GridServiceDescription lookup(String serviceDescriptionId) {
        return this.directory.get(serviceDescriptionId);
    }

    public void remove(String serviceDescriptionId) {
        this.directory.remove(serviceDescriptionId);
    }

    public MessageReceiverHandler getMessageReceiverHandler() {
        return new WhitePagesServer(this);
    }

    public void registerSocketService(Grid grid, String id, String ip, int port) {
        WhitePagesImpl.doRegisterSocketService(grid, id, ip, port);
    }

    public static void doRegisterSocketService(Grid grid, String id, String ip, int port) {
        GridServiceDescription service;
        CoreServicesLookupImpl coreServicesWP = (CoreServicesLookupImpl)grid.get(CoreServicesLookup.class);
        GridServiceDescriptionImpl gsd = (GridServiceDescriptionImpl)coreServicesWP.lookup(WhitePages.class);
        if (gsd == null) {
            gsd = new GridServiceDescriptionImpl(WhitePages.class);
        }
        if ((service = coreServicesWP.getServices().get(WhitePages.class.getName())) == null) {
            coreServicesWP.getServices().put(WhitePages.class.getName(), gsd);
            service = gsd;
        }
        Address address = null;
        address = service.getAddresses().get("socket") != null ? service.getAddresses().get("socket") : service.addAddress("socket");
        InetSocketAddress[] addresses = (InetSocketAddress[])address.getObject();
        if (addresses != null && addresses.length >= 1) {
            InetSocketAddress[] newAddresses = new InetSocketAddress[addresses.length + 1];
            if (addresses != null) {
                System.arraycopy(addresses, 0, newAddresses, 0, addresses.length);
            }
            newAddresses[addresses.length] = new InetSocketAddress(ip, port);
            WhitePagesServiceConfiguration conf = new WhitePagesServiceConfiguration(newAddresses);
            service.setData(conf);
        } else {
            InetSocketAddress[] newAddress = new InetSocketAddress[]{new InetSocketAddress(ip, port)};
            address.setObject(newAddress);
            WhitePagesServiceConfiguration conf = new WhitePagesServiceConfiguration(newAddress);
            service.setData(conf);
        }
    }
}

