/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.timer.impl;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.drools.grid.Grid;
import org.drools.grid.GridServiceDescription;
import org.drools.grid.MessageReceiverHandlerFactoryService;
import org.drools.grid.internal.responsehandlers.BlockingMessageResponseHandler;
import org.drools.grid.io.Conversation;
import org.drools.grid.io.ConversationManager;
import org.drools.grid.io.MessageReceiverHandler;
import org.drools.grid.io.impl.CommandImpl;
import org.drools.grid.timer.impl.ScheduledJob;
import org.drools.grid.timer.impl.SchedulerServer;
import org.drools.grid.timer.impl.SchedulerServiceConfiguration;
import org.drools.grid.timer.impl.UuidJobHandle;
import org.drools.time.Job;
import org.drools.time.JobContext;
import org.drools.time.JobHandle;
import org.drools.time.SchedulerService;
import org.drools.time.Trigger;
import org.drools.time.impl.MultiJobHandle;

public class SchedulerClient
implements SchedulerService,
MessageReceiverHandlerFactoryService {
    private GridServiceDescription<SchedulerService> schedulerGsd;
    private ConversationManager conversationManager;
    private Grid grid;
    private AtomicLong idCounter = new AtomicLong();

    public SchedulerClient(Grid grid, GridServiceDescription schedulerGsd) {
        this.grid = grid;
        this.schedulerGsd = schedulerGsd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object sendMessage(ConversationManager conversationManager, Serializable addr, String id, Object body) {
        InetSocketAddress[] sockets = null;
        if (addr instanceof InetSocketAddress[]) {
            sockets = (InetSocketAddress[])addr;
        } else if (addr instanceof InetSocketAddress) {
            sockets = new InetSocketAddress[]{(InetSocketAddress)addr};
        }
        BlockingMessageResponseHandler handler = new BlockingMessageResponseHandler();
        Exception exception = null;
        Conversation conv = null;
        for (InetSocketAddress socket : sockets) {
            try {
                conv = conversationManager.startConversation("", socket, id);
                conv.sendMessage(body, handler);
                exception = null;
            }
            catch (Exception e) {
                exception = e;
                conv.endConversation();
            }
            if (exception == null) break;
        }
        if (exception != null) {
            throw new RuntimeException("Unable to send message", exception);
        }
        try {
            Object object = handler.getMessage().getBody();
            return object;
        }
        finally {
            conv.endConversation();
        }
    }

    public MessageReceiverHandler getMessageReceiverHandler() {
        return new SchedulerServer(this);
    }

    public JobHandle scheduleJob(Job job, JobContext ctx, Trigger trigger) {
        ArrayList<UuidJobHandle> jobHandles = new ArrayList<UuidJobHandle>();
        UuidJobHandle jobhandle = new UuidJobHandle();
        SchedulerServiceConfiguration conf = (SchedulerServiceConfiguration)this.schedulerGsd.getData();
        if (conf == null && this.schedulerGsd.getAddresses().get("socket") == null) {
            SchedulerService sched = null;
            try {
                sched = (SchedulerService)this.grid.get(Class.forName(this.schedulerGsd.getServiceInterface().getCanonicalName()));
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(SchedulerClient.class.getName()).log(Level.SEVERE, null, ex);
            }
            return sched.scheduleJob(job, ctx, trigger);
        }
        int redundancy = 1;
        InetSocketAddress[] addresses = null;
        if (conf != null) {
            redundancy = conf.getRedundancy();
            addresses = conf.getServices(this.grid);
        }
        if (addresses == null && this.schedulerGsd.getAddresses() != null && this.schedulerGsd.getAddresses().get("socket") != null) {
            addresses = (InetSocketAddress[])this.schedulerGsd.getAddresses().get("socket").getObject();
        }
        for (int i = 0; i < redundancy; ++i) {
            int bucket = jobhandle.hashCode() % addresses.length;
            InetSocketAddress socket = addresses[bucket];
            CommandImpl cmd = new CommandImpl("Scheduler.scheduleJob", Arrays.asList(new ScheduledJob(jobhandle, job, ctx, trigger, null)));
            UuidJobHandle handle = (UuidJobHandle)SchedulerClient.sendMessage(this.conversationManager, socket, this.schedulerGsd.getId(), cmd);
            jobHandles.add(handle);
        }
        return new MultiJobHandle(this.idCounter.incrementAndGet(), jobHandles);
    }

    public boolean removeJob(JobHandle jobHandle) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void registerSocketService(Grid grid, String id, String ip, int port) {
        throw new UnsupportedOperationException();
    }
}

