/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.info;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.drools.marshalling.impl.InputMarshaller;
import org.drools.marshalling.impl.MarshallerReaderContext;
import org.drools.marshalling.impl.MarshallerWriteContext;
import org.drools.marshalling.impl.OutputMarshaller;
import org.drools.process.instance.WorkItem;
import org.drools.runtime.Environment;

@Entity
@SequenceGenerator(name="workItemInfoIdSeq", sequenceName="WORKITEMINFO_ID_SEQ")
public class WorkItemInfo {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="workItemInfoIdSeq")
    private Long workItemId;
    @Version
    @Column(name="OPTLOCK")
    private int version;
    private String name;
    private Date creationDate;
    private long processInstanceId;
    private long state;
    @Lob
    private byte[] workItemByteArray;
    @Transient
    private WorkItem workItem;
    @Transient
    private Environment env;

    protected WorkItemInfo() {
    }

    public WorkItemInfo(WorkItem workItem, Environment env) {
        this.workItem = workItem;
        this.name = workItem.getName();
        this.creationDate = new Date();
        this.processInstanceId = workItem.getProcessInstanceId();
        this.env = env;
    }

    public Long getId() {
        return this.workItemId;
    }

    public int getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public long getState() {
        return this.state;
    }

    public byte[] getWorkItemByteArray() {
        return this.workItemByteArray;
    }

    public WorkItem getWorkItem(Environment env) {
        this.env = env;
        if (this.workItem == null) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(this.workItemByteArray);
                MarshallerReaderContext context = new MarshallerReaderContext((InputStream)bais, null, null, null, env);
                this.workItem = InputMarshaller.readWorkItem((MarshallerReaderContext)context);
                context.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("IOException while loading process instance: " + e.getMessage());
            }
        }
        return this.workItem;
    }

    @PreUpdate
    public void update() {
        this.state = this.workItem.getState();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            MarshallerWriteContext context = new MarshallerWriteContext((OutputStream)baos, null, null, null, null, this.env);
            OutputMarshaller.writeWorkItem((MarshallerWriteContext)context, (WorkItem)this.workItem);
            context.close();
            this.workItemByteArray = baos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("IOException while storing workItem " + this.workItem.getId() + ": " + e.getMessage());
        }
    }

    public void setId(Long id) {
        this.workItemId = id;
    }
}

