/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.cdr.Parameter;
import org.milyn.cdr.ProfileTargetingExpression;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.classpath.ClasspathUtils;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.ContentHandler;
import org.milyn.delivery.Filter;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.expression.ExecutionContextExpressionEvaluator;
import org.milyn.expression.ExpressionEvaluator;
import org.milyn.io.StreamUtils;
import org.milyn.profile.Profile;
import org.milyn.resource.URIResourceLocator;
import org.milyn.util.ClassUtil;
import org.milyn.xml.DomUtils;
import org.milyn.xml.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmooksResourceConfiguration {
    private static Log logger = LogFactory.getLog(SmooksResourceConfiguration.class);
    public static final String PARAM_RESTYPE = "restype";
    public static final String PARAM_RESDATA = "resdata";
    public static final String XML_DEF_PREFIX = "xmldef:".toLowerCase();
    private static URIResourceLocator uriResourceLocator = new URIResourceLocator();
    public static final String DOCUMENT_FRAGMENT_SELECTOR = "#document";
    public static final String LEGACY_DOCUMENT_FRAGMENT_SELECTOR = "$document";
    public static final String DOCUMENT_VOID_SELECTOR = "$void";
    private String selector;
    private String[] contextualSelector;
    private boolean isContextualSelector;
    private String targetElement;
    private String targetAttribute;
    private String targetProfile;
    private String[] profileTargetingExpressionStrings;
    private ProfileTargetingExpression[] profileTargetingExpressions;
    private String resource;
    private boolean isInline = false;
    private ExpressionEvaluator expressionEvaluator;
    private String resourceType;
    private boolean isXmlDef;
    private LinkedHashMap<String, Object> parameters = new LinkedHashMap();
    private int parameterCount;
    private SmooksResourceConfiguration globalParams;
    private String namespaceURI;
    private boolean defaultResource = false;

    public SmooksResourceConfiguration() {
        this.setSelector("none");
        this.setTargetProfile(Profile.DEFAULT_PROFILE);
    }

    public SmooksResourceConfiguration(String selector) {
        this.setSelector(selector);
        this.setTargetProfile(Profile.DEFAULT_PROFILE);
    }

    public SmooksResourceConfiguration(String selector, String resource) {
        this(selector, Profile.DEFAULT_PROFILE, resource);
    }

    public SmooksResourceConfiguration(String selector, String targetProfile, String resource) {
        this(selector);
        this.setTargetProfile(targetProfile);
        this.setResource(resource);
    }

    public Object clone() {
        SmooksResourceConfiguration clone = new SmooksResourceConfiguration();
        clone.selector = this.selector;
        clone.contextualSelector = this.contextualSelector;
        clone.targetElement = this.targetElement;
        clone.targetAttribute = this.targetAttribute;
        clone.isContextualSelector = this.isContextualSelector;
        clone.targetProfile = this.targetProfile;
        clone.defaultResource = this.defaultResource;
        clone.profileTargetingExpressionStrings = this.profileTargetingExpressionStrings;
        clone.profileTargetingExpressions = this.profileTargetingExpressions;
        clone.resource = this.resource;
        clone.isInline = this.isInline;
        clone.resourceType = this.resourceType;
        clone.isXmlDef = this.isXmlDef;
        if (this.parameters != null) {
            clone.parameters = (LinkedHashMap)this.parameters.clone();
        }
        clone.parameterCount = this.parameterCount;
        clone.namespaceURI = this.namespaceURI;
        clone.expressionEvaluator = this.expressionEvaluator;
        return clone;
    }

    public void attachGlobalParameters(ApplicationContext appContext) {
        if (this.globalParams == null) {
            this.globalParams = appContext.getStore().getGlobalParams();
        }
    }

    public SmooksResourceConfiguration merge(SmooksResourceConfiguration config) {
        SmooksResourceConfiguration clone = (SmooksResourceConfiguration)this.clone();
        clone.parameters.clear();
        clone.parameters.putAll(config.parameters);
        clone.parameters.putAll(this.parameters);
        return clone;
    }

    public void addParmeters(SmooksResourceConfiguration config) {
        this.parameters.putAll(config.parameters);
    }

    public SmooksResourceConfiguration(String selector, String selectorNamespaceURI, String targetProfile, String resource) {
        this(selector, targetProfile, resource);
        this.setSelectorNamespaceURI(selectorNamespaceURI);
    }

    public void setSelector(String selector) {
        if (selector == null || selector.trim().equals("")) {
            throw new IllegalArgumentException("null or empty 'selector' arg in constructor call.");
        }
        if (selector.equals(LEGACY_DOCUMENT_FRAGMENT_SELECTOR)) {
            selector = DOCUMENT_FRAGMENT_SELECTOR;
        }
        this.selector = selector.toLowerCase().intern();
        int docSelectorIndex = selector.trim().indexOf(DOCUMENT_FRAGMENT_SELECTOR);
        if (docSelectorIndex != -1 && docSelectorIndex > 0) {
            throw new SmooksConfigurationException("Invalid selector '" + selector + "'.  '" + DOCUMENT_FRAGMENT_SELECTOR + "' token can only exist at the start of the selector.");
        }
        if (selector.startsWith("/")) {
            selector = DOCUMENT_FRAGMENT_SELECTOR + selector;
        }
        this.isXmlDef = selector.startsWith(XML_DEF_PREFIX);
        this.contextualSelector = SmooksResourceConfiguration.parseSelector(selector);
        this.targetElement = this.extractTargetElement(this.contextualSelector);
        this.targetAttribute = SmooksResourceConfiguration.extractTargetAttribute(this.contextualSelector);
        this.isContextualSelector = this.contextualSelector.length > 1;
    }

    public static String[] parseSelector(String selector) {
        if (selector.startsWith("/")) {
            selector = selector.substring(1);
        }
        String[] splitTokens = selector.indexOf(47) != -1 ? selector.split("/") : selector.split(" +");
        for (int i = 0; i < splitTokens.length; ++i) {
            String splitToken = splitTokens[i];
            if (!splitToken.startsWith("@")) {
                splitTokens[i] = splitToken.toLowerCase();
            }
            if (!splitToken.equals(LEGACY_DOCUMENT_FRAGMENT_SELECTOR)) continue;
            splitTokens[i] = DOCUMENT_FRAGMENT_SELECTOR;
        }
        return splitTokens;
    }

    public void setSelectorNamespaceURI(String namespaceURI) {
        if (namespaceURI != null) {
            this.namespaceURI = namespaceURI.equals("*") ? null : namespaceURI.intern();
        }
    }

    public void setResource(String resource) {
        this.resource = resource;
        if (resource != null) {
            try {
                new URI(resource);
                this.isInline = false;
            }
            catch (Exception e) {
                this.isInline = true;
            }
        }
    }

    public boolean isInline() {
        return this.isInline;
    }

    public String getTargetProfile() {
        return this.targetProfile;
    }

    public void setTargetProfile(String targetProfile) {
        if (targetProfile == null || targetProfile.trim().equals("")) {
            targetProfile = Profile.DEFAULT_PROFILE;
        }
        this.targetProfile = targetProfile;
        this.parseTargetingExpressions(targetProfile);
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getSelector() {
        return this.selector;
    }

    public String[] getContextualSelector() {
        return this.contextualSelector;
    }

    public String getTargetElement() {
        return this.targetElement;
    }

    public String getTargetAttribute() {
        return this.targetAttribute;
    }

    public String getSelectorNamespaceURI() {
        return this.namespaceURI;
    }

    public ProfileTargetingExpression[] getProfileTargetingExpressions() {
        return this.profileTargetingExpressions;
    }

    public String getResource() {
        return this.resource;
    }

    public void setConditionEvaluator(ExpressionEvaluator expressionEvaluator) {
        if (expressionEvaluator != null && !(expressionEvaluator instanceof ExecutionContextExpressionEvaluator)) {
            throw new UnsupportedOperationException("Unsupported ExpressionEvaluator type '" + expressionEvaluator.getClass().getName() + "'.  Currently only support '" + ExecutionContextExpressionEvaluator.class.getName() + "' implementations.");
        }
        this.expressionEvaluator = expressionEvaluator;
    }

    public ExpressionEvaluator getConditionEvaluator() {
        return this.expressionEvaluator;
    }

    public boolean isDefaultResource() {
        return this.defaultResource;
    }

    public void setDefaultResource(boolean defaultResource) {
        this.defaultResource = defaultResource;
    }

    public String getResourceType() {
        if (this.isJavaResource()) {
            return "class";
        }
        String restype = this.getStringParameter(PARAM_RESTYPE);
        if (restype != null && !restype.trim().equals("")) {
            if (this.getParameter(PARAM_RESDATA) == null) {
                logger.warn((Object)"Resource configuration defined with 'restype' parameter but no 'resdata' parameter.");
            }
        } else {
            restype = this.resourceType != null ? this.resourceType : this.getExtension(this.getResource());
        }
        return restype;
    }

    private void parseTargetingExpressions(String targetProfiles) {
        StringTokenizer tokenizer = new StringTokenizer(targetProfiles.toLowerCase(), ",|;");
        if (tokenizer.countTokens() == 0) {
            throw new IllegalArgumentException("Empty 'target-profile'. [" + this.selector + "][" + this.resource + "]");
        }
        this.profileTargetingExpressionStrings = new String[tokenizer.countTokens()];
        this.profileTargetingExpressions = new ProfileTargetingExpression[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String expression;
            this.profileTargetingExpressionStrings[i] = expression = tokenizer.nextToken();
            this.profileTargetingExpressions[i] = new ProfileTargetingExpression(expression);
            ++i;
        }
    }

    private String getExtension(String path) {
        int extensionIndex;
        File resFile;
        String resName;
        if (path != null && (resName = (resFile = new File(path)).getName()) != null && !resName.trim().equals("") && (extensionIndex = resName.lastIndexOf(46)) != -1 && extensionIndex + 1 < resName.length()) {
            return resName.substring(extensionIndex + 1);
        }
        return null;
    }

    public Parameter setParameter(String name, String value) {
        Parameter param = new Parameter(name, value);
        this.setParameter(param);
        return param;
    }

    public Parameter setParameter(String name, String type, String value) {
        Parameter param = new Parameter(name, value, type);
        this.setParameter(param);
        return param;
    }

    public void setParameter(Parameter parameter) {
        Object exists;
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap();
        }
        if ((exists = this.parameters.get(parameter.getName())) == null) {
            this.parameters.put(parameter.getName(), parameter);
        } else if (exists instanceof Parameter) {
            Vector<Parameter> paramList = new Vector<Parameter>();
            paramList.add((Parameter)exists);
            paramList.add(parameter);
            this.parameters.put(parameter.getName(), paramList);
        } else if (exists instanceof List) {
            ((List)exists).add(parameter);
        }
        ++this.parameterCount;
    }

    public Parameter getParameter(String name) {
        if (this.parameters == null) {
            return null;
        }
        Object parameter = this.parameters.get(name);
        if (parameter instanceof List) {
            return (Parameter)((List)parameter).get(0);
        }
        if (parameter instanceof Parameter) {
            return (Parameter)parameter;
        }
        if (this.globalParams != null) {
            return this.globalParams.getParameter(name);
        }
        return null;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public List getParameterList() {
        if (this.parameters == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(this.parameters.values());
        return list;
    }

    public List getParameters(String name) {
        if (this.parameters == null) {
            return null;
        }
        Object parameter = this.parameters.get(name);
        if (parameter instanceof List) {
            return (List)parameter;
        }
        if (parameter instanceof Parameter) {
            Vector<Object> paramList = new Vector<Object>();
            paramList.add(parameter);
            return paramList;
        }
        return null;
    }

    public String getStringParameter(String name) {
        Parameter parameter = this.getParameter(name);
        return parameter != null ? parameter.value : null;
    }

    public String getStringParameter(String name, String defaultVal) {
        Parameter parameter = this.getParameter(name);
        return parameter != null ? parameter.value : defaultVal;
    }

    public boolean getBoolParameter(String name, boolean defaultVal) {
        if (this.parameters == null) {
            return defaultVal;
        }
        String paramVal = this.getStringParameter(name);
        if (paramVal == null) {
            return defaultVal;
        }
        if ((paramVal = paramVal.trim()).equals("true")) {
            return true;
        }
        if (paramVal.equals("false")) {
            return false;
        }
        return defaultVal;
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    public boolean isXmlDef() {
        return this.isXmlDef;
    }

    public String toString() {
        return "Target Profile: [" + Arrays.asList(this.profileTargetingExpressionStrings) + "], Selector: [" + this.selector + "], Selector Namespace URI: [" + this.namespaceURI + "], Resource: [" + this.resource + "], Num Params: [" + this.getParameterCount() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() {
        String paramBasedData = this.getStringParameter(PARAM_RESDATA);
        if (paramBasedData != null) {
            return paramBasedData.getBytes();
        }
        if (this.resource != null) {
            InputStream resStream = null;
            try {
                resStream = uriResourceLocator.getResource(this.resource);
            }
            catch (Exception e) {
                return this.getInlineResourceBytes();
            }
            try {
                byte[] resourceBytes = null;
                if (resStream == null) {
                    throw new IOException("Resource [" + this.resource + "] not found.");
                }
                try {
                    resourceBytes = StreamUtils.readStream((InputStream)resStream);
                }
                finally {
                    resStream.close();
                }
                return resourceBytes;
            }
            catch (IOException e) {
                return this.getInlineResourceBytes();
            }
        }
        return null;
    }

    private byte[] getInlineResourceBytes() {
        try {
            return this.resource.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            return this.resource.getBytes();
        }
    }

    public Class toJavaResource() {
        if (this.resource == null) {
            return null;
        }
        String className = ClasspathUtils.toClassName((String)this.resource);
        try {
            return ClassUtil.forName((String)className, this.getClass());
        }
        catch (ClassNotFoundException e) {
            if (this.resource.equals(className)) {
                logger.debug((Object)("Resource path [" + this.resource + "] looks as though it may be a Java resource reference.  If so, this class is not available on the classpath."));
            }
            return null;
        }
    }

    public boolean isJavaResource() {
        return this.toJavaResource() != null;
    }

    public boolean isJavaContentHandler() {
        Class runtimeClass = this.toJavaResource();
        return runtimeClass != null && ContentHandler.class.isAssignableFrom(runtimeClass);
    }

    public boolean isTargetedAtNamespace(String namespace) {
        if (this.namespaceURI != null) {
            return this.namespaceURI.equals(namespace);
        }
        return true;
    }

    public boolean isSelectorContextual() {
        return this.isContextualSelector;
    }

    public boolean isTargetedAtElementContext(Element element) {
        Node currentNode = element;
        Index index = new Index();
        if (currentNode == null || currentNode.getNodeType() != 1) {
            return false;
        }
        index.i = this.contextualSelector.length - 1;
        if (this.contextualSelector[index.i].charAt(0) == '@') {
            index.i = this.contextualSelector.length - 2;
        }
        while (index.i >= 0) {
            Element currentElement = currentNode;
            String elementName = DomUtils.getName(currentElement);
            String parentElementName = null;
            Node parentNode = currentElement.getParentNode();
            if (parentNode != null && parentNode.getNodeType() == 1) {
                parentElementName = DomUtils.getName((Element)parentNode);
            }
            if (!this.isTargetedAtElementContext(elementName, parentElementName, index)) {
                return false;
            }
            if (parentElementName == null) {
                return true;
            }
            currentNode = parentNode;
        }
        return true;
    }

    public boolean isTargetedAtElementContext(SAXElement element) {
        SAXElement currentElement = element;
        Index index = new Index();
        if (currentElement == null) {
            return false;
        }
        index.i = this.contextualSelector.length - 1;
        if (this.contextualSelector[index.i].charAt(0) == '@') {
            index.i = this.contextualSelector.length - 2;
        }
        while (index.i >= 0) {
            String elementName = currentElement.getName().getLocalPart();
            SAXElement parentElement = currentElement.getParent();
            String parentElementName = null;
            if (parentElement != null) {
                parentElementName = parentElement.getName().getLocalPart();
            }
            if (!this.isTargetedAtElementContext(elementName, parentElementName, index)) {
                return false;
            }
            if (parentElement == null) {
                return true;
            }
            currentElement = parentElement;
        }
        return true;
    }

    private boolean isTargetedAtElementContext(String elementName, String parentElementName, Index index) {
        if (this.contextualSelector[index.i].equals("*")) {
            index.i--;
        } else if (this.contextualSelector[index.i].equals("**")) {
            String parentContextToken;
            if (index.i == 0) {
                return true;
            }
            if (index.i == 1) {
                if (parentElementName == null && this.contextualSelector[index.i - 1].equals(DOCUMENT_FRAGMENT_SELECTOR)) {
                    return true;
                }
                if (parentElementName == null) {
                    return false;
                }
            } else if (parentElementName == null) {
                return false;
            }
            if ((parentContextToken = this.contextualSelector[index.i - 1]).equals("*") || parentContextToken.equals("**")) {
                index.i--;
            } else if (parentContextToken.equalsIgnoreCase(parentElementName)) {
                index.i--;
            }
        } else {
            if (!this.contextualSelector[index.i].equalsIgnoreCase(elementName)) {
                return false;
            }
            index.i--;
        }
        if (parentElementName == null && index.i >= 0 && !this.contextualSelector[index.i].equals("**")) {
            return this.contextualSelector[index.i].equals(DOCUMENT_FRAGMENT_SELECTOR);
        }
        return true;
    }

    public boolean isTargetedAtElement(Element element) {
        if (!this.assertConditionTrue()) {
            return false;
        }
        if (!this.isTargetedAtNamespace(element.getNamespaceURI())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Not applying resource [" + this + "] to element [" + DomUtils.getXPath(element) + "].  Element not in namespace [" + this.getSelectorNamespaceURI() + "]."));
            }
            return false;
        }
        if (this.isSelectorContextual() && !this.isTargetedAtElementContext(element)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Not applying resource [" + this + "] to element [" + DomUtils.getXPath(element) + "].  This resource is only targeted at '" + DomUtils.getName(element) + "' when in the following context '" + this.getSelector() + "'."));
            }
            return false;
        }
        return true;
    }

    public boolean isTargetedAtElement(SAXElement element) {
        if (this.expressionEvaluator != null && !this.assertConditionTrue()) {
            return false;
        }
        if (this.namespaceURI != null && !this.isTargetedAtNamespace(element.getName().getNamespaceURI())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Not applying resource [" + this + "] to element [" + element.getName() + "].  Element not in namespace [" + this.getSelectorNamespaceURI() + "]."));
            }
            return false;
        }
        if (this.isContextualSelector && !this.isTargetedAtElementContext(element)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Not applying resource [" + this + "] to element [" + element.getName() + "].  This resource is only targeted at '" + element.getName().getLocalPart() + "' when in the following context '" + this.getSelector() + "'."));
            }
            return false;
        }
        return true;
    }

    private boolean assertConditionTrue() {
        if (this.expressionEvaluator == null) {
            return true;
        }
        ExecutionContextExpressionEvaluator evaluator = (ExecutionContextExpressionEvaluator)this.expressionEvaluator;
        ExecutionContext execContext = Filter.getCurrentExecutionContext();
        return evaluator.eval(execContext);
    }

    public String toXML() {
        StringBuilder builder = new StringBuilder();
        builder.append("<resource-config selector=\"" + this.selector + "\"");
        if (this.namespaceURI != null) {
            builder.append(" selector-namespace=\"" + this.namespaceURI + "\"");
        }
        if (this.targetProfile != null && !this.targetProfile.equals(Profile.DEFAULT_PROFILE)) {
            builder.append(" target-profile=\"" + this.targetProfile + "\"");
        }
        builder.append("\">\n");
        if (this.resource != null) {
            String resourceStartEl = this.resourceType != null ? "<resource type=\"" + this.resourceType + "\">" : "<resource>";
            if (this.resource.length() < 300) {
                builder.append("\t" + resourceStartEl + this.resource + "</resource>\n");
            } else {
                builder.append("\t" + resourceStartEl + this.resource.substring(0, 300) + " ... more</resource>\n");
            }
        }
        if (this.expressionEvaluator != null) {
            builder.append("\t<condition evaluator=\"" + this.expressionEvaluator.getClass().getName() + "\">" + this.expressionEvaluator.getExpression() + "</condition>\n");
        }
        if (this.parameters != null) {
            Set<String> paramNames = this.parameters.keySet();
            for (String paramName : paramNames) {
                List params = this.getParameters(paramName);
                for (Object param : params) {
                    Element element = ((Parameter)param).getXml();
                    String value = element != null ? XmlUtil.serialize((NodeList)element.getChildNodes()) : ((Parameter)param).getValue();
                    builder.append("\t<param name=\"" + paramName + "\">" + value + "</param>\n");
                }
            }
        }
        builder.append("</resource-config>");
        return builder.toString();
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        Set<String> names = this.parameters.keySet();
        for (String name : names) {
            properties.setProperty(name, this.getStringParameter(name));
        }
        return properties;
    }

    private String extractTargetElement(String[] contextualSelector) {
        if (contextualSelector != null) {
            String token = contextualSelector[contextualSelector.length - 1];
            if (token.startsWith("@") && contextualSelector.length > 1) {
                token = contextualSelector[contextualSelector.length - 2];
            }
            return token;
        }
        return null;
    }

    public static String extractTargetAttribute(String[] selectorTokens) {
        StringBuffer selectorProp = new StringBuffer();
        for (String selectorToken : selectorTokens) {
            if (!selectorToken.trim().startsWith("@")) continue;
            selectorProp.append(selectorToken.substring(1));
        }
        if (selectorProp.length() == 0) {
            return null;
        }
        return selectorProp.toString();
    }

    private class Index {
        private int i;

        private Index() {
        }
    }
}

