/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery.sax;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.milyn.SmooksException;
import org.milyn.assertion.AssertArgument;
import org.milyn.delivery.sax.SAXText;
import org.milyn.delivery.sax.SAXUtil;
import org.milyn.delivery.sax.SAXVisitor;
import org.milyn.delivery.sax.SAXWriterAccessException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAXElement {
    private QName name;
    private Attributes attributes;
    private SAXElement parent;
    private Writer writer;
    private List<SAXText> text;
    private StringWriter textAccumulator;
    private String accumulatedText;
    private Object l1Cache;
    private SAXVisitor l1CacheOwner;
    private Map<SAXVisitor, Object> l2Caches;

    public SAXElement(String namespaceURI, String localName, String qName, Attributes attributes, SAXElement parent) {
        this.name = SAXElement.toQName(namespaceURI, localName, qName);
        this.attributes = this.copyAttributes(attributes);
        this.parent = parent;
    }

    public SAXElement(QName name, Attributes attributes, SAXElement parent) {
        this.name = name;
        this.attributes = this.copyAttributes(attributes);
        this.parent = parent;
    }

    public static QName toQName(String namespaceURI, String localName, String qName) {
        if (namespaceURI != null) {
            int colonIndex;
            if (namespaceURI.length() != 0 && qName != null && (colonIndex = qName.indexOf(58)) != -1) {
                String prefix = qName.substring(0, colonIndex);
                String qNameLocalName = qName.substring(colonIndex + 1);
                return new QName(namespaceURI.intern(), qNameLocalName, prefix);
            }
            if (localName != null && localName.length() != 0) {
                return new QName(namespaceURI, localName);
            }
            if (qName != null && qName.length() != 0) {
                return new QName(namespaceURI, qName);
            }
            SAXElement.thowInvalidNameException(namespaceURI, localName, qName);
        } else {
            if (localName != null && localName.length() != 0) {
                return new QName(localName);
            }
            SAXElement.thowInvalidNameException(namespaceURI, localName, qName);
        }
        return null;
    }

    private Attributes copyAttributes(Attributes attributes) {
        AttributesImpl attributesCopy = new AttributesImpl();
        attributesCopy.setAttributes(attributes);
        return attributesCopy;
    }

    private static void thowInvalidNameException(String namespaceURI, String localName, String qName) {
        throw new IllegalArgumentException("Invalid SAXELement name paramaters: namespaceURI='" + namespaceURI + "', localName='" + localName + "', qName='" + qName + "'.");
    }

    public void accumulateText() {
        if (this.text == null) {
            this.text = new ArrayList<SAXText>(){

                @Override
                public boolean add(SAXText saxText) {
                    if (SAXElement.this.textAccumulator != null) {
                        SAXElement.this.accumulatedText = null;
                    }
                    return super.add((SAXText)saxText.clone());
                }
            };
        }
    }

    public List<SAXText> getText() {
        return this.text;
    }

    public String getTextContent() throws SmooksException {
        if (this.text == null) {
            throw new SmooksException("Illegal call to getTextAsString().  SAXElement instance not accumulating SAXText Objects.  You must call SAXElement.accumulateText().");
        }
        if (this.textAccumulator == null) {
            this.textAccumulator = new StringWriter();
        }
        if (this.accumulatedText == null) {
            this.textAccumulator.getBuffer().setLength(0);
            for (SAXText textObj : this.text) {
                try {
                    textObj.toWriter(this.textAccumulator);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unexpected IOException.", e);
                }
            }
            this.accumulatedText = this.textAccumulator.toString();
        }
        return this.accumulatedText;
    }

    public Writer getWriter(SAXVisitor visitor) throws SAXWriterAccessException {
        return this.writer;
    }

    public void setWriter(Writer writer, SAXVisitor visitor) throws SAXWriterAccessException {
        this.writer = writer;
    }

    public boolean isWriterOwner(SAXVisitor visitor) {
        return true;
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName name) {
        AssertArgument.isNotNull((Object)name, (String)"name");
        this.name = name;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Attributes attributes) {
        AssertArgument.isNotNull((Object)attributes, (String)"attributes");
        this.attributes = attributes;
    }

    public String getAttribute(String attribute) {
        return SAXUtil.getAttribute(attribute, this.attributes);
    }

    public String getAttribute(String namespaceURI, String attribute) {
        return SAXUtil.getAttribute(namespaceURI, attribute, this.attributes, "");
    }

    public Object getCache() {
        return this.l1Cache;
    }

    public void setCache(Object cache) {
        this.l1Cache = cache;
    }

    public Object getCache(SAXVisitor visitor) {
        if (visitor == this.l1CacheOwner) {
            return this.l1Cache;
        }
        if (this.l2Caches == null) {
            return null;
        }
        return this.l2Caches.get(visitor);
    }

    public void setCache(SAXVisitor visitor, Object cache) {
        if (this.l1Cache == null && this.l1CacheOwner == null) {
            this.l1Cache = cache;
            this.l1CacheOwner = visitor;
            return;
        }
        if (this.l2Caches == null) {
            this.l2Caches = new HashMap<SAXVisitor, Object>();
        }
        this.l2Caches.put(visitor, cache);
    }

    public SAXElement getParent() {
        return this.parent;
    }

    public void setParent(SAXElement parent) {
        this.parent = parent;
    }

    public String toString() {
        return this.getName().toString();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public Element toDOMElement(Document document) {
        Element element = this.name.getNamespaceURI() != null ? (this.name.getPrefix().length() != 0 ? document.createElementNS(this.name.getNamespaceURI(), this.name.getPrefix() + ":" + this.name.getLocalPart()) : document.createElementNS(this.name.getNamespaceURI(), this.name.getLocalPart())) : document.createElement(this.name.getLocalPart());
        int attributeCount = this.attributes.getLength();
        for (int i = 0; i < attributeCount; ++i) {
            Attr attribute;
            String namespace = this.attributes.getURI(i);
            String value = this.attributes.getValue(i);
            if (namespace != null) {
                String qName = this.attributes.getQName(i);
                attribute = document.createAttributeNS(namespace, qName);
                attribute.setValue(value);
                element.setAttributeNode(attribute);
                continue;
            }
            String localName = this.attributes.getLocalName(i);
            attribute = document.createAttribute(localName);
            attribute.setValue(value);
            element.setAttributeNode(attribute);
        }
        return element;
    }
}

