/*
 * Decompiled with CFR 0.152.
 */
package org.drools.command.impl;

import java.util.HashMap;
import java.util.Map;
import org.drools.command.Context;
import org.drools.command.ContextManager;

public class ContextImpl
implements Context {
    private ContextManager manager;
    private String name;
    private Map<String, Object> context = new HashMap<String, Object>();
    private Context parent;
    private int depth;

    public ContextImpl(String name, ContextManager manager) {
        this.name = name;
        this.manager = manager;
        this.depth = 0;
    }

    public ContextImpl(String name, ContextManager manager, Context delegate) {
        this.name = name;
        this.manager = manager;
        this.setParent(delegate);
        this.depth = ((ContextImpl)delegate).getDepth() + 1;
    }

    public void setParent(Context delegate) {
        this.parent = delegate;
    }

    public ContextManager getContextManager() {
        return this.manager;
    }

    public String getName() {
        return this.name;
    }

    public Object get(String identifier) {
        Object object = this.context.get(identifier);
        if (object == null && this.parent != null) {
            object = this.parent.get(identifier);
        }
        return object;
    }

    public void set(String name, Object object) {
        this.context.put(name, object);
    }

    public int getDepth() {
        return this.depth;
    }

    public void remove(String name) {
        this.context.remove(name);
    }

    public String toString() {
        return "ContextImpl [name=" + this.name + ", parent=" + this.parent.getName() + ", context=" + this.context + "]";
    }
}

