/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.beans;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.KnowledgeBase;
import org.drools.command.Command;
import org.drools.event.process.ProcessEventListener;
import org.drools.event.rule.AgendaEventListener;
import org.drools.event.rule.WorkingMemoryEventListener;
import org.drools.grid.GridNode;
import org.drools.runtime.CommandExecutor;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.process.WorkItemHandler;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NamedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractKnowledgeSessionBeanFactory
implements FactoryBean,
InitializingBean,
BeanNameAware,
NamedBean {
    private GridNode node;
    private Map<String, WorkItemHandler> workItems;
    private KnowledgeSessionConfiguration conf;
    private KnowledgeBase kbase;
    private String beanName;
    private String name;
    private List<Command<?>> batch;
    protected List<AgendaEventListener> agendaEventListeners;
    protected List<ProcessEventListener> processEventListeners;
    protected List<WorkingMemoryEventListener> workingMemoryEventListeners;
    protected List<Object> groupedListeners = new ArrayList<Object>();

    public AbstractKnowledgeSessionBeanFactory() {
        this.agendaEventListeners = new ArrayList<AgendaEventListener>();
        this.processEventListeners = new ArrayList<ProcessEventListener>();
        this.workingMemoryEventListeners = new ArrayList<WorkingMemoryEventListener>();
    }

    public Object getObject() throws Exception {
        return this.getCommandExecutor();
    }

    public Map<String, WorkItemHandler> getWorkItems() {
        return this.workItems;
    }

    public void setWorkItems(Map<String, WorkItemHandler> workItems) {
        this.workItems = workItems;
    }

    public KnowledgeSessionConfiguration getConf() {
        return this.conf;
    }

    public void setConf(KnowledgeSessionConfiguration conf) {
        this.conf = conf;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public KnowledgeBase getKbase() {
        return this.kbase;
    }

    public void setKbase(KnowledgeBase kbase) {
        this.kbase = kbase;
    }

    public boolean isSingleton() {
        return true;
    }

    public List<Command<?>> getBatch() {
        return this.batch;
    }

    public void setBatch(List<Command<?>> commands) {
        this.batch = commands;
    }

    public final void afterPropertiesSet() throws Exception {
        if (this.kbase == null) {
            throw new IllegalArgumentException("kbase property is mandatory");
        }
        if (this.name == null) {
            this.name = this.beanName;
        }
        this.internalAfterPropertiesSet();
    }

    protected abstract CommandExecutor getCommandExecutor();

    protected abstract void internalAfterPropertiesSet();

    public GridNode getNode() {
        return this.node;
    }

    public void setNode(GridNode node) {
        this.node = node;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setEventListenersFromGroup(List<Object> eventListenerList) {
        for (Object eventListener : eventListenerList) {
            if (eventListener instanceof AgendaEventListener) {
                this.agendaEventListeners.add((AgendaEventListener)eventListener);
            }
            if (eventListener instanceof WorkingMemoryEventListener) {
                this.workingMemoryEventListeners.add((WorkingMemoryEventListener)eventListener);
            }
            if (!(eventListener instanceof ProcessEventListener)) continue;
            this.processEventListeners.add((ProcessEventListener)eventListener);
        }
        this.groupedListeners.addAll(eventListenerList);
    }

    public void setEventListeners(Map<String, List> eventListenerMap) {
        for (String key : eventListenerMap.keySet()) {
            List eventListenerList = eventListenerMap.get(key);
            if ("agenda-event-listener".equalsIgnoreCase(key)) {
                for (Object eventListener : eventListenerList) {
                    if (!(eventListener instanceof AgendaEventListener)) continue;
                    this.agendaEventListeners.add((AgendaEventListener)eventListener);
                }
                continue;
            }
            if ("working-memory-event-listener".equalsIgnoreCase(key)) {
                for (Object eventListener : eventListenerList) {
                    if (!(eventListener instanceof WorkingMemoryEventListener)) continue;
                    this.workingMemoryEventListeners.add((WorkingMemoryEventListener)eventListener);
                }
                continue;
            }
            if (!"process-event-listener".equalsIgnoreCase(key)) continue;
            for (Object eventListener : eventListenerList) {
                if (!(eventListener instanceof ProcessEventListener)) continue;
                this.processEventListeners.add((ProcessEventListener)eventListener);
            }
        }
    }

    public List<AgendaEventListener> getAgendaEventListeners() {
        return this.agendaEventListeners;
    }

    public void setAgendaEventListeners(List<AgendaEventListener> agendaEventListeners) {
        this.agendaEventListeners = agendaEventListeners;
    }

    public List<ProcessEventListener> getProcessEventListeners() {
        return this.processEventListeners;
    }

    public void setProcessEventListeners(List<ProcessEventListener> processEventListeners) {
        this.processEventListeners = processEventListeners;
    }

    public List<WorkingMemoryEventListener> getWorkingMemoryEventListeners() {
        return this.workingMemoryEventListeners;
    }

    public void setWorkingMemoryEventListeners(List<WorkingMemoryEventListener> workingMemoryEventListeners) {
        this.workingMemoryEventListeners = workingMemoryEventListeners;
    }
}

