/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.broker.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.drools.examples.broker.model.Company;
import org.drools.examples.broker.model.StockTick;
import org.drools.examples.broker.ui.CompanyPanel;
import org.drools.examples.broker.ui.LogPanel;
import org.drools.examples.broker.ui.ScrollingBanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokerWindow {
    private final JFrame frame;
    private final Map<String, CompanyPanel> companies;
    private final LogPanel logPanel = new LogPanel();
    private final ScrollingBanner banner = new ScrollingBanner();

    public BrokerWindow(Collection<Company> companies) {
        this.companies = new HashMap<String, CompanyPanel>();
        this.frame = this.buildFrame(companies);
    }

    private JFrame buildFrame(Collection<Company> companies) {
        JPanel contentPanel = new JPanel(new BorderLayout());
        JPanel companyListPanel = new JPanel(new GridLayout(0, 2));
        for (Company company : companies) {
            CompanyPanel panel = new CompanyPanel(company);
            this.companies.put(company.getSymbol(), panel);
            companyListPanel.add(panel);
        }
        contentPanel.add((Component)companyListPanel, "West");
        contentPanel.add((Component)this.logPanel, "Center");
        contentPanel.add((Component)this.banner, "South");
        JFrame frame = new JFrame();
        frame.setContentPane(contentPanel);
        frame.setDefaultCloseOperation(3);
        frame.setTitle("Drools Fusion Example: Simple Broker");
        frame.setResizable(true);
        frame.pack();
        frame.setLocationRelativeTo(null);
        Thread bannerThread = new Thread(this.banner);
        bannerThread.setPriority(bannerThread.getPriority() - 1);
        bannerThread.start();
        return frame;
    }

    public void show() {
        this.frame.setVisible(true);
    }

    public void updateCompany(String symbol) {
        this.companies.get(symbol).updateCompany();
    }

    public void log(String message) {
        this.logPanel.log(message);
    }

    public void updateTick(StockTick tick) {
        this.banner.addTick(tick);
    }
}

