/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.BinaryPredicateSupport;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.util.ExpressionToPredicateAdapter;
import org.apache.camel.util.ObjectHelper;

public final class PredicateBuilder {
    private PredicateBuilder() {
    }

    public static Predicate toPredicate(Expression expression) {
        return ExpressionToPredicateAdapter.toPredicate(expression);
    }

    public static Predicate not(final Predicate predicate) {
        ObjectHelper.notNull(predicate, "predicate");
        return new Predicate(){

            @Override
            public boolean matches(Exchange exchange) {
                return !predicate.matches(exchange);
            }

            public String toString() {
                return "not (" + predicate + ")";
            }
        };
    }

    public static Predicate and(final Predicate left, final Predicate right) {
        ObjectHelper.notNull(left, "left");
        ObjectHelper.notNull(right, "right");
        return new Predicate(){

            @Override
            public boolean matches(Exchange exchange) {
                return left.matches(exchange) && right.matches(exchange);
            }

            public String toString() {
                return "(" + left + ") and (" + right + ")";
            }
        };
    }

    public static Predicate or(final Predicate left, final Predicate right) {
        ObjectHelper.notNull(left, "left");
        ObjectHelper.notNull(right, "right");
        return new Predicate(){

            @Override
            public boolean matches(Exchange exchange) {
                return left.matches(exchange) || right.matches(exchange);
            }

            public String toString() {
                return "(" + left + ") or (" + right + ")";
            }
        };
    }

    public static Predicate in(final Predicate ... predicates) {
        ObjectHelper.notNull(predicates, "predicates");
        return new Predicate(){

            @Override
            public boolean matches(Exchange exchange) {
                for (Predicate in : predicates) {
                    if (!in.matches(exchange)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return "in (" + Arrays.asList(predicates) + ")";
            }
        };
    }

    public static Predicate isEqualTo(Expression left, Expression right) {
        return new BinaryPredicateSupport(left, right){

            @Override
            protected boolean matches(Exchange exchange, Object leftValue, Object rightValue) {
                if (leftValue == null && rightValue == null) {
                    return true;
                }
                if (leftValue == null || rightValue == null) {
                    return false;
                }
                return ObjectHelper.typeCoerceEquals(exchange.getContext().getTypeConverter(), leftValue, rightValue);
            }

            @Override
            protected String getOperationText() {
                return "==";
            }
        };
    }

    public static Predicate isNotEqualTo(Expression left, Expression right) {
        return new BinaryPredicateSupport(left, right){

            @Override
            protected boolean matches(Exchange exchange, Object leftValue, Object rightValue) {
                if (leftValue == null && rightValue == null) {
                    return false;
                }
                if (leftValue == null || rightValue == null) {
                    return true;
                }
                return ObjectHelper.typeCoerceNotEquals(exchange.getContext().getTypeConverter(), leftValue, rightValue);
            }

            @Override
            protected String getOperationText() {
                return "!=";
            }
        };
    }

    public static Predicate isLessThan(Expression left, Expression right) {
        return new BinaryPredicateSupport(left, right){

            @Override
            protected boolean matches(Exchange exchange, Object leftValue, Object rightValue) {
                if (leftValue == null && rightValue == null) {
                    return true;
                }
                if (leftValue == null || rightValue == null) {
                    return false;
                }
                return ObjectHelper.typeCoerceCompare(exchange.getContext().getTypeConverter(), leftValue, rightValue) < 0;
            }

            @Override
            protected String getOperationText() {
                return "<";
            }
        };
    }

    public static Predicate isLessThanOrEqualTo(Expression left, Expression right) {
        return new BinaryPredicateSupport(left, right){

            @Override
            protected boolean matches(Exchange exchange, Object leftValue, Object rightValue) {
                if (leftValue == null && rightValue == null) {
                    return true;
                }
                if (leftValue == null || rightValue == null) {
                    return false;
                }
                return ObjectHelper.typeCoerceCompare(exchange.getContext().getTypeConverter(), leftValue, rightValue) <= 0;
            }

            @Override
            protected String getOperationText() {
                return "<=";
            }
        };
    }

    public static Predicate isGreaterThan(Expression left, Expression right) {
        return new BinaryPredicateSupport(left, right){

            @Override
            protected boolean matches(Exchange exchange, Object leftValue, Object rightValue) {
                if (leftValue == null && rightValue == null) {
                    return false;
                }
                if (leftValue == null || rightValue == null) {
                    return false;
                }
                return ObjectHelper.typeCoerceCompare(exchange.getContext().getTypeConverter(), leftValue, rightValue) > 0;
            }

            @Override
            protected String getOperationText() {
                return ">";
            }
        };
    }

    public static Predicate isGreaterThanOrEqualTo(Expression left, Expression right) {
        return new BinaryPredicateSupport(left, right){

            @Override
            protected boolean matches(Exchange exchange, Object leftValue, Object rightValue) {
                if (leftValue == null && rightValue == null) {
                    return true;
                }
                if (leftValue == null || rightValue == null) {
                    return false;
                }
                return ObjectHelper.typeCoerceCompare(exchange.getContext().getTypeConverter(), leftValue, rightValue) >= 0;
            }

            @Override
            protected String getOperationText() {
                return ">=";
            }
        };
    }

    public static Predicate contains(Expression left, Expression right) {
        return new BinaryPredicateSupport(left, right){

            @Override
            protected boolean matches(Exchange exchange, Object leftValue, Object rightValue) {
                if (leftValue == null && rightValue == null) {
                    return true;
                }
                if (leftValue == null || rightValue == null) {
                    return false;
                }
                return ObjectHelper.contains(leftValue, rightValue);
            }

            @Override
            protected String getOperationText() {
                return "contains";
            }
        };
    }

    public static Predicate isNull(Expression expression) {
        return new BinaryPredicateSupport(expression, ExpressionBuilder.constantExpression(null)){

            @Override
            protected boolean matches(Exchange exchange, Object leftValue, Object rightValue) {
                if (leftValue == null) {
                    return true;
                }
                return ObjectHelper.typeCoerceEquals(exchange.getContext().getTypeConverter(), leftValue, rightValue);
            }

            @Override
            protected String getOperationText() {
                return "is";
            }
        };
    }

    public static Predicate isNotNull(Expression expression) {
        return new BinaryPredicateSupport(expression, ExpressionBuilder.constantExpression(null)){

            @Override
            protected boolean matches(Exchange exchange, Object leftValue, Object rightValue) {
                if (leftValue != null) {
                    return true;
                }
                return ObjectHelper.typeCoerceNotEquals(exchange.getContext().getTypeConverter(), leftValue, rightValue);
            }

            @Override
            protected String getOperationText() {
                return "is not";
            }
        };
    }

    public static Predicate isInstanceOf(final Expression expression, final Class<?> type) {
        ObjectHelper.notNull(expression, "expression");
        ObjectHelper.notNull(type, "type");
        return new Predicate(){

            @Override
            public boolean matches(Exchange exchange) {
                Object value = expression.evaluate(exchange, Object.class);
                return type.isInstance(value);
            }

            public String toString() {
                return expression + " instanceof " + type.getCanonicalName();
            }
        };
    }

    public static Predicate startsWith(Expression left, Expression right) {
        return new BinaryPredicateSupport(left, right){

            @Override
            protected boolean matches(Exchange exchange, Object leftValue, Object rightValue) {
                if (leftValue == null && rightValue == null) {
                    return true;
                }
                if (leftValue == null || rightValue == null) {
                    return false;
                }
                String leftStr = exchange.getContext().getTypeConverter().convertTo(String.class, leftValue);
                String rightStr = exchange.getContext().getTypeConverter().convertTo(String.class, rightValue);
                if (leftStr != null && rightStr != null) {
                    return leftStr.startsWith(rightStr);
                }
                return false;
            }

            @Override
            protected String getOperationText() {
                return "startsWith";
            }
        };
    }

    public static Predicate endsWith(Expression left, Expression right) {
        return new BinaryPredicateSupport(left, right){

            @Override
            protected boolean matches(Exchange exchange, Object leftValue, Object rightValue) {
                if (leftValue == null && rightValue == null) {
                    return true;
                }
                if (leftValue == null || rightValue == null) {
                    return false;
                }
                String leftStr = exchange.getContext().getTypeConverter().convertTo(String.class, leftValue);
                String rightStr = exchange.getContext().getTypeConverter().convertTo(String.class, rightValue);
                if (leftStr != null && rightStr != null) {
                    return leftStr.endsWith(rightStr);
                }
                return false;
            }

            @Override
            protected String getOperationText() {
                return "endsWith";
            }
        };
    }

    public static Predicate regex(Expression expression, String regex) {
        return PredicateBuilder.regex(expression, Pattern.compile(regex));
    }

    public static Predicate regex(final Expression expression, final Pattern pattern) {
        ObjectHelper.notNull(expression, "expression");
        ObjectHelper.notNull(pattern, "pattern");
        return new Predicate(){

            @Override
            public boolean matches(Exchange exchange) {
                String value = expression.evaluate(exchange, String.class);
                if (value != null) {
                    Matcher matcher = pattern.matcher(value);
                    return matcher.matches();
                }
                return false;
            }

            public String toString() {
                return expression + ".matches('" + pattern + "')";
            }
        };
    }

    public static Predicate and(List<Predicate> predicates) {
        Predicate answer = null;
        for (Predicate predicate : predicates) {
            if (answer == null) {
                answer = predicate;
                continue;
            }
            answer = PredicateBuilder.and(answer, predicate);
        }
        return answer;
    }
}

