/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Traceable;
import org.apache.camel.api.management.PerformanceCounter;
import org.apache.camel.management.DelegatePerformanceCounter;
import org.apache.camel.management.mbean.ManagedPerformanceCounter;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentationProcessor
extends DelegateAsyncProcessor
implements Traceable {
    private static final transient Logger LOG = LoggerFactory.getLogger(InstrumentationProcessor.class);
    private PerformanceCounter counter;
    private String type;

    public InstrumentationProcessor() {
    }

    public InstrumentationProcessor(PerformanceCounter counter) {
        this.counter = counter;
    }

    @Override
    public String toString() {
        return "Instrumentation" + (this.type != null ? ":" + this.type : "") + "[" + this.processor + "]";
    }

    public void setCounter(Object counter) {
        ManagedPerformanceCounter mpc = null;
        if (counter instanceof ManagedPerformanceCounter) {
            mpc = (ManagedPerformanceCounter)counter;
        }
        if (this.counter instanceof DelegatePerformanceCounter) {
            ((DelegatePerformanceCounter)this.counter).setCounter(mpc);
        } else {
            this.counter = mpc;
        }
    }

    @Override
    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        final StopWatch watch = this.counter != null && this.counter.isStatisticsEnabled() ? new StopWatch() : null;
        return super.process(exchange, new AsyncCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void done(boolean doneSync) {
                try {
                    if (watch != null) {
                        InstrumentationProcessor.this.recordTime(exchange, watch.stop());
                    }
                }
                finally {
                    callback.done(doneSync);
                }
            }
        });
    }

    protected void recordTime(Exchange exchange, long duration) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{}Recording duration: {} millis for exchange: {}", new Object[]{this.type != null ? this.type + ": " : "", duration, exchange});
        }
        if (!exchange.isFailed() && exchange.getException() == null) {
            this.counter.completedExchange(exchange, duration);
        } else {
            this.counter.failedExchange(exchange);
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getTraceLabel() {
        if (this.processor instanceof Traceable) {
            return ((Traceable)((Object)this.processor)).getTraceLabel();
        }
        return "";
    }
}

