/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.dom.DOMElementVisitor;
import org.milyn.delivery.ordering.Consumer;
import org.milyn.delivery.ordering.Producer;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXUtil;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.milyn.event.report.annotation.VisitAfterReport;
import org.milyn.event.report.annotation.VisitBeforeReport;
import org.milyn.expression.ExpressionEvaluationException;
import org.milyn.expression.MVELExpressionEvaluator;
import org.milyn.javabean.Bean;
import org.milyn.javabean.BeanPopulator;
import org.milyn.javabean.BeanRuntimeInfo;
import org.milyn.javabean.BeanUtils;
import org.milyn.javabean.DataDecodeException;
import org.milyn.javabean.DataDecoder;
import org.milyn.javabean.decoders.StringDecoder;
import org.milyn.javabean.lifecycle.BeanLifecycle;
import org.milyn.javabean.lifecycle.BeanRepositoryLifecycleEvent;
import org.milyn.javabean.lifecycle.BeanRepositoryLifecycleObserver;
import org.milyn.javabean.repository.BeanId;
import org.milyn.javabean.repository.BeanIdRegister;
import org.milyn.javabean.repository.BeanRepository;
import org.milyn.javabean.repository.BeanRepositoryManager;
import org.milyn.util.ClassUtil;
import org.milyn.util.CollectionsUtil;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@VisitBeforeReport(condition="parameters.containsKey('wireBeanIdName')", summary="Create bean lifecycle observer for bean <b>${resource.parameters.wireBeanId!'undefined'}</b>.", detailTemplate="reporting/BeanInstancePopulatorReport_Before.html")
@VisitAfterReport(condition="!parameters.containsKey('wireBeanIdName')", summary="Populating <b>${resource.parameters.beanId}</b> with a value from this element.", detailTemplate="reporting/BeanInstancePopulatorReport_After.html")
public class BeanInstancePopulator
implements DOMElementVisitor,
SAXVisitBefore,
SAXVisitAfter,
Producer,
Consumer {
    private static Log logger = LogFactory.getLog(BeanInstancePopulator.class);
    private static String EC_DEFAULT_EXTEND_LIFECYCLE = BeanInstancePopulator.class + "#" + BeanPopulator.GLOBAL_DEFAULT_EXTEND_LIFECYCLE;
    private String id;
    @ConfigParam(name="beanId")
    private String beanIdName;
    @ConfigParam(name="wireBeanId", defaultVal="##NULL")
    private String wireBeanIdName;
    @ConfigParam(defaultVal="##NULL")
    private MVELExpressionEvaluator expression;
    @ConfigParam(defaultVal="##NULL")
    private String property;
    @ConfigParam(defaultVal="##NULL")
    private String setterMethod;
    @ConfigParam(defaultVal="##NULL")
    private String valueAttributeName;
    @ConfigParam(defaultVal="##NULL")
    private String initVal;
    private MVELExpressionEvaluator initValIsdefTest;
    private MVELExpressionEvaluator initValExpression;
    @ConfigParam(name="type", defaultVal="##NULL")
    private String typeAlias;
    @ConfigParam(name="default", defaultVal="##NULL")
    private String defaultVal;
    @ConfigParam(defaultVal="##NULL")
    private Boolean extendLifecycle;
    @AppContext
    private ApplicationContext appContext;
    private BeanRepositoryManager beanRepositoryManager;
    private BeanId beanId;
    private BeanId wireBeanId;
    private BeanRuntimeInfo beanRuntimeInfo;
    private BeanRuntimeInfo wiredBeanRuntimeInfo;
    private Method propertySetterMethod;
    private boolean checkedForSetterMethod;
    private boolean isAttribute = true;
    private DataDecoder decoder;
    private String mapKeyAttribute;
    private boolean beanWiring;
    public static final String VALUE_ATTRIBUTE_NAME = "valueAttributeName";

    public void setBeanId(String beanId) {
        this.beanIdName = beanId;
    }

    public void setWireBeanId(String wireBeanId) {
        this.wireBeanIdName = wireBeanId;
    }

    public void setExpression(MVELExpressionEvaluator expression) {
        this.expression = expression;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setInitVal(String initVal) {
        this.initVal = initVal;
    }

    public void setSetterMethod(String setterMethod) {
        this.setterMethod = setterMethod;
    }

    public void setValueAttributeName(String valueAttributeName) {
        this.valueAttributeName = valueAttributeName;
    }

    public void setTypeAlias(String typeAlias) {
        this.typeAlias = typeAlias;
    }

    public void setDecoder(DataDecoder decoder) {
        this.decoder = decoder;
    }

    public void setDefaultVal(String defaultVal) {
        this.defaultVal = defaultVal;
    }

    public void setExtendLifecycle(Boolean extendLifecycle) {
        this.extendLifecycle = extendLifecycle;
    }

    @Initialize
    public void initialize() throws SmooksConfigurationException {
        this.buildId();
        this.beanRuntimeInfo = BeanRuntimeInfo.getBeanRuntimeInfo(this.beanIdName, this.appContext);
        this.beanWiring = this.wireBeanIdName != null;
        this.isAttribute = this.valueAttributeName != null;
        this.beanRepositoryManager = BeanRepositoryManager.getInstance(this.appContext);
        BeanIdRegister beanIdRegister = this.beanRepositoryManager.getBeanIdRegister();
        this.beanId = beanIdRegister.getBeanId(this.beanIdName);
        if (this.setterMethod == null && this.property == null) {
            if (this.beanWiring && (this.beanRuntimeInfo.getClassification() == BeanRuntimeInfo.Classification.NON_COLLECTION || this.beanRuntimeInfo.getClassification() == BeanRuntimeInfo.Classification.MAP_COLLECTION)) {
                this.property = this.wireBeanIdName;
            } else if (this.beanRuntimeInfo.getClassification() == BeanRuntimeInfo.Classification.NON_COLLECTION) {
                throw new SmooksConfigurationException("Binding configuration for beanIdName='" + this.beanIdName + "' must contain " + "either a 'property' or 'setterMethod' attribute definition, unless the target bean is a Collection/Array." + "  Bean is type '" + this.beanRuntimeInfo.getPopulateType().getName() + "'.");
            }
        }
        if (this.beanRuntimeInfo.getClassification() == BeanRuntimeInfo.Classification.MAP_COLLECTION && this.property != null) {
            this.property = this.property.trim();
            if (this.property.length() > 1 && this.property.charAt(0) == '@') {
                this.mapKeyAttribute = this.property.substring(1);
            }
        }
        if (this.initVal != null) {
            this.initValIsdefTest = new MVELExpressionEvaluator();
            this.initValIsdefTest.setExpression("bean." + this.property);
            this.initValExpression = new MVELExpressionEvaluator();
            this.initValExpression.setExpression(this.initVal);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Bean Instance Populator created for [" + this.beanIdName + "].  property=" + this.property));
        }
    }

    private void buildId() {
        StringBuilder idBuilder = new StringBuilder();
        idBuilder.append(BeanInstancePopulator.class.getName());
        idBuilder.append("#");
        idBuilder.append(this.beanIdName);
        if (this.property != null) {
            idBuilder.append("#").append(this.property);
        }
        if (this.setterMethod != null) {
            idBuilder.append("#").append(this.setterMethod).append("()");
        }
        if (this.wireBeanIdName != null) {
            idBuilder.append("#").append(this.wireBeanIdName);
        }
        this.id = idBuilder.toString();
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.checkBeanExists(executionContext);
        if (this.beanWiring) {
            this.bindBeanValue(executionContext);
        } else if (this.isAttribute) {
            this.bindDomDataValue(element, executionContext);
        }
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        this.checkBeanExists(executionContext);
        if (!this.beanWiring && !this.isAttribute) {
            this.bindDomDataValue(element, executionContext);
        }
        if (this.beanWiring) {
            this.extendLifecycle(executionContext);
        }
    }

    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.checkBeanExists(executionContext);
        if (this.beanWiring) {
            this.bindBeanValue(executionContext);
        } else if (this.isAttribute) {
            this.bindSaxDataValue(element, executionContext);
        } else if (this.expression == null) {
            element.accumulateText();
        }
    }

    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.checkBeanExists(executionContext);
        if (!this.beanWiring && !this.isAttribute) {
            this.bindSaxDataValue(element, executionContext);
        }
        if (this.beanWiring) {
            this.extendLifecycle(executionContext);
        }
    }

    private void checkBeanExists(ExecutionContext executionContext) {
        BeanRepository beanRepository = BeanRepositoryManager.getBeanRepository(executionContext);
        if (beanRepository.getBean(this.beanId) == null) {
            throw new SmooksConfigurationException("Can't populate object '" + this.beanRuntimeInfo.getPopulateType().getName() + "' with bean id '" + this.beanId + "' because there is no object in the bean context under that bean id.");
        }
    }

    private void bindDomDataValue(Element element, ExecutionContext executionContext) {
        String mapPropertyName;
        String dataString = this.isAttribute ? DomUtils.getAttributeValue((Element)element, (String)this.valueAttributeName) : DomUtils.getAllText((Element)element, (boolean)false);
        if (this.mapKeyAttribute != null) {
            mapPropertyName = DomUtils.getAttributeValue((Element)element, (String)this.mapKeyAttribute);
            if (mapPropertyName == null) {
                mapPropertyName = DomUtils.getName((Element)element);
            }
        } else {
            mapPropertyName = this.property != null ? this.property : DomUtils.getName((Element)element);
        }
        if (this.expression != null) {
            this.bindExpressionValue(mapPropertyName, executionContext);
        } else {
            this.setPropertyValue(mapPropertyName, this.decodeDataString(dataString, executionContext), executionContext);
        }
    }

    private void bindSaxDataValue(SAXElement element, ExecutionContext executionContext) {
        String mapPropertyName;
        String dataString = this.isAttribute ? SAXUtil.getAttribute((String)this.valueAttributeName, (Attributes)element.getAttributes()) : element.getTextContent();
        if (this.mapKeyAttribute != null) {
            mapPropertyName = SAXUtil.getAttribute((String)this.mapKeyAttribute, (Attributes)element.getAttributes(), null);
            if (mapPropertyName == null) {
                mapPropertyName = element.getName().getLocalPart();
            }
        } else {
            mapPropertyName = this.property != null ? this.property : element.getName().getLocalPart();
        }
        if (this.expression != null) {
            this.bindExpressionValue(mapPropertyName, executionContext);
        } else {
            this.setPropertyValue(mapPropertyName, this.decodeDataString(dataString, executionContext), executionContext);
        }
    }

    private BeanId getWireBeanId() {
        if (this.wireBeanId == null) {
            this.wireBeanId = this.beanRepositoryManager.getBeanIdRegister().getBeanId(this.wireBeanIdName);
        }
        if (this.wireBeanId == null) {
            this.wireBeanId = this.beanRepositoryManager.getBeanIdRegister().register(this.wireBeanIdName);
        }
        return this.wireBeanId;
    }

    private void bindBeanValue(final ExecutionContext executionContext) {
        final BeanId targetBeanId = this.getWireBeanId();
        final BeanRepository beanRepository = BeanRepositoryManager.getBeanRepository(executionContext);
        Object bean = beanRepository.getBean(targetBeanId);
        if (bean == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Registering bean BEGIN wiring observer for wiring bean '" + targetBeanId + "' onto target bean '" + this.beanId.getName() + "'."));
            }
            beanRepository.addBeanLifecycleObserver(targetBeanId, BeanLifecycle.BEGIN, this.getId(), false, new BeanRepositoryLifecycleObserver(){

                public void onBeanLifecycleEvent(BeanRepositoryLifecycleEvent event) {
                    Object eventBean = event.getBean();
                    beanRepository.associateLifecycles(BeanInstancePopulator.this.beanId, targetBeanId);
                    BeanInstancePopulator.this.populateAndSetPropertyValue(eventBean, beanRepository, targetBeanId, executionContext);
                }
            });
        } else {
            this.populateAndSetPropertyValue(bean, beanRepository, targetBeanId, executionContext);
        }
    }

    private void populateAndSetPropertyValue(Object bean, BeanRepository beanRepository, BeanId targetBeanId, final ExecutionContext executionContext) {
        BeanRuntimeInfo wiredBeanRI = this.getWiredBeanRuntimeInfo();
        if (wiredBeanRI != null && wiredBeanRI.getClassification() == BeanRuntimeInfo.Classification.ARRAY_COLLECTION) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Registering bean CHANGE wiring observer for wiring bean '" + targetBeanId + "' onto target bean '" + this.beanId.getName() + "' after it has been converted from a List to an array."));
            }
            beanRepository.addBeanLifecycleObserver(targetBeanId, BeanLifecycle.CHANGE, this.getId(), true, new BeanRepositoryLifecycleObserver(){

                public void onBeanLifecycleEvent(BeanRepositoryLifecycleEvent event) {
                    BeanInstancePopulator.this.setPropertyValue(BeanInstancePopulator.this.property, event.getBean(), executionContext);
                }
            });
        } else {
            this.setPropertyValue(this.property, bean, executionContext);
        }
    }

    private void extendLifecycle(ExecutionContext executionContext) {
        Boolean doExtendLifecycle = this.extendLifecycle;
        if (doExtendLifecycle == null) {
            doExtendLifecycle = this.isDefaultExtendLifecycle(executionContext);
        }
        if (!doExtendLifecycle.booleanValue()) {
            BeanRepository beanRepository = BeanRepositoryManager.getBeanRepository(executionContext);
            beanRepository.removeBeanLifecycleObserver(this.getWireBeanId(), BeanLifecycle.BEGIN, this.getId());
        }
    }

    private boolean isDefaultExtendLifecycle(ExecutionContext executionContext) {
        Boolean defaultExtendLifecycle = (Boolean)executionContext.getAttribute((Object)EC_DEFAULT_EXTEND_LIFECYCLE);
        if (defaultExtendLifecycle == null) {
            String wireAfterElementStr = executionContext.getConfigParameter(BeanPopulator.GLOBAL_DEFAULT_EXTEND_LIFECYCLE, "false");
            defaultExtendLifecycle = Boolean.parseBoolean(wireAfterElementStr.trim());
            executionContext.setAttribute((Object)EC_DEFAULT_EXTEND_LIFECYCLE, (Object)defaultExtendLifecycle);
        }
        return defaultExtendLifecycle;
    }

    private void bindExpressionValue(String mapPropertyName, ExecutionContext executionContext) {
        Map<String, Object> beanMap = BeanRepositoryManager.getBeanRepository(executionContext).getBeanMap();
        if (this.initVal != null) {
            Object bean = BeanRepositoryManager.getBeanRepository(executionContext).getBean(this.beanId);
            try {
                HashMap<String, Object> testMap = new HashMap<String, Object>();
                testMap.put("bean", bean);
                this.initValIsdefTest.getValue(testMap);
            }
            catch (ExpressionEvaluationException e) {
                Object initValObj = this.initValExpression.getValue(beanMap);
                this.decodeAndSetPropertyValue(mapPropertyName, initValObj, executionContext);
            }
        }
        Object dataObject = this.expression.getValue(beanMap);
        this.decodeAndSetPropertyValue(mapPropertyName, dataObject, executionContext);
    }

    private void decodeAndSetPropertyValue(String mapPropertyName, Object dataObject, ExecutionContext executionContext) {
        if (dataObject instanceof String) {
            this.setPropertyValue(mapPropertyName, this.decodeDataString((String)dataObject, executionContext), executionContext);
        } else {
            this.setPropertyValue(mapPropertyName, dataObject, executionContext);
        }
    }

    private void setPropertyValue(String mapPropertyName, Object dataObject, ExecutionContext executionContext) {
        if (dataObject == null) {
            return;
        }
        Object bean = BeanRepositoryManager.getBeanRepository(executionContext).getBean(this.beanId);
        BeanRuntimeInfo.Classification beanType = this.beanRuntimeInfo.getClassification();
        this.createPropertySetterMethod(bean, dataObject.getClass());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting data object '" + this.wireBeanIdName + "' (" + dataObject.getClass().getName() + ") on target bean '" + this.beanId + "'."));
        }
        try {
            if (this.propertySetterMethod != null) {
                this.propertySetterMethod.invoke(bean, dataObject);
            } else if (beanType == BeanRuntimeInfo.Classification.MAP_COLLECTION) {
                ((Map)bean).put(mapPropertyName, dataObject);
            } else if (beanType == BeanRuntimeInfo.Classification.ARRAY_COLLECTION || beanType == BeanRuntimeInfo.Classification.COLLECTION_COLLECTION) {
                ((Collection)bean).add(dataObject);
            } else if (this.propertySetterMethod == null) {
                if (this.setterMethod != null) {
                    throw new SmooksConfigurationException("Bean [" + this.beanIdName + "] configuration invalid.  Bean setter method [" + this.setterMethod + "(" + dataObject.getClass().getName() + ")] not found on type [" + this.beanRuntimeInfo.getPopulateType().getName() + "].  You may need to set a 'decoder' on the binding config.");
                }
                if (this.property != null) {
                    throw new SmooksConfigurationException("Bean [" + this.beanIdName + "] configuration invalid.  Bean setter method [" + ClassUtil.toSetterName((String)this.property) + "(" + dataObject.getClass().getName() + ")] not found on type [" + this.beanRuntimeInfo.getPopulateType().getName() + "].  You may need to set a 'decoder' on the binding config.");
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new SmooksConfigurationException("Error invoking bean setter method [" + ClassUtil.toSetterName((String)this.property) + "] on bean instance class type [" + bean.getClass() + "].", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new SmooksConfigurationException("Error invoking bean setter method [" + ClassUtil.toSetterName((String)this.property) + "] on bean instance class type [" + bean.getClass() + "].", (Throwable)e);
        }
    }

    private void createPropertySetterMethod(Object bean, Class<?> parameter) {
        if (!this.checkedForSetterMethod && this.propertySetterMethod == null) {
            String methodName = null;
            if (this.setterMethod != null && !this.setterMethod.trim().equals("")) {
                methodName = this.setterMethod;
            } else if (this.property != null && !this.property.trim().equals("")) {
                methodName = ClassUtil.toSetterName((String)this.property);
            }
            if (methodName != null) {
                this.propertySetterMethod = this.createPropertySetterMethod(bean, methodName, parameter);
            }
            this.checkedForSetterMethod = true;
        }
    }

    private synchronized Method createPropertySetterMethod(Object bean, String setterName, Class<?> setterParamType) {
        if (this.propertySetterMethod == null) {
            this.propertySetterMethod = BeanUtils.createSetterMethod(setterName, bean, setterParamType);
        }
        return this.propertySetterMethod;
    }

    private Object decodeDataString(String dataString, ExecutionContext executionContext) throws DataDecodeException {
        if ((dataString == null || dataString.equals("")) && this.defaultVal != null) {
            if (this.defaultVal.equals("null")) {
                return null;
            }
            dataString = this.defaultVal;
        }
        if (this.decoder == null) {
            this.decoder = this.getDecoder(executionContext);
        }
        try {
            return this.decoder.decode(dataString);
        }
        catch (DataDecodeException e) {
            throw new DataDecodeException("Failed to decode binding value '" + dataString + "' for property '" + this.property + "' on bean '" + this.beanId.getName() + "'.", (Throwable)e);
        }
    }

    private DataDecoder getDecoder(ExecutionContext executionContext) throws DataDecodeException {
        List decoders = executionContext.getDeliveryConfig().getObjects("decoder:" + this.typeAlias);
        if (decoders == null || decoders.isEmpty()) {
            this.decoder = this.typeAlias != null ? DataDecoder.Factory.create((String)this.typeAlias) : this.resolveDecoderReflectively();
        } else {
            if (!(decoders.get(0) instanceof DataDecoder)) {
                throw new DataDecodeException("Configured decoder '" + this.typeAlias + ":" + decoders.get(0).getClass().getName() + "' is not an instance of " + DataDecoder.class.getName());
            }
            this.decoder = (DataDecoder)decoders.get(0);
        }
        return this.decoder;
    }

    private DataDecoder resolveDecoderReflectively() throws DataDecodeException {
        Class<?> bindType;
        DataDecoder resolvedDecoder;
        Method bindingMethod;
        String bindingMember;
        String string = bindingMember = this.setterMethod != null ? this.setterMethod : this.property;
        if (bindingMember != null && this.beanRuntimeInfo.getClassification() == BeanRuntimeInfo.Classification.NON_COLLECTION && (bindingMethod = Bean.getBindingMethod(bindingMember, this.beanRuntimeInfo.getPopulateType())) != null && (resolvedDecoder = DataDecoder.Factory.create(bindType = bindingMethod.getParameterTypes()[0])) != null) {
            return resolvedDecoder;
        }
        return new StringDecoder();
    }

    private BeanRuntimeInfo getWiredBeanRuntimeInfo() {
        if (this.wiredBeanRuntimeInfo == null) {
            this.wiredBeanRuntimeInfo = BeanRuntimeInfo.getBeanRuntimeInfo(this.wireBeanIdName, this.appContext);
        }
        return this.wiredBeanRuntimeInfo;
    }

    private String getId() {
        return this.id;
    }

    public Set<? extends Object> getProducts() {
        return CollectionsUtil.toSet((Object[])new String[]{this.beanIdName + "." + this.property, "]." + this.property});
    }

    public boolean consumes(Object object) {
        if (object.equals(this.beanIdName)) {
            return true;
        }
        if (this.wireBeanIdName != null && object.equals(this.wireBeanIdName)) {
            return true;
        }
        return this.expression != null && this.expression.getExpression().indexOf(object.toString()) != -1;
    }
}

