/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.impl;

import java.net.InetSocketAddress;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.grid.Grid;
import org.drools.grid.GridNode;
import org.drools.grid.GridServiceDescription;
import org.drools.grid.MessageReceiverHandlerFactoryService;
import org.drools.grid.impl.GridNodeServer;
import org.drools.grid.io.MessageReceiverHandler;
import org.drools.grid.io.impl.NodeData;
import org.drools.grid.remote.StatefulKnowledgeSessionRemoteClient;
import org.drools.grid.service.directory.WhitePages;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.util.ServiceRegistry;
import org.drools.util.ServiceRegistryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridNodeImpl
implements GridNode,
MessageReceiverHandlerFactoryService {
    private String id;
    private final Map<String, Object> localContext = new ConcurrentHashMap<String, Object>();
    private final Map<String, String> sessionids = new ConcurrentHashMap<String, String>();
    private final Map<String, String> reversesessionids = new ConcurrentHashMap<String, String>();
    private final ServiceRegistry serviceRegistry = ServiceRegistryImpl.getInstance();
    private static Logger logger = LoggerFactory.getLogger(GridNodeImpl.class);

    public GridNodeImpl() {
        this.id = UUID.randomUUID().toString();
    }

    public GridNodeImpl(String id) {
        this.id = id;
    }

    @Override
    public <T> T get(String identifier, Class<T> cls) {
        Object service = null;
        if (cls.isAssignableFrom(String.class)) {
            if (logger.isDebugEnabled()) {
                logger.debug(" ### GridNodeImpl(" + this + "): Resolving String.class with ID: " + identifier + ")");
            }
            if (logger.isTraceEnabled()) {
                logger.trace(" ### GridNodeImpl: \t available sessionsid: " + this.sessionids + ")");
                logger.trace(" ### GridNodeImpl: \t available reverse sessionsid: " + this.reversesessionids + ")");
            }
            service = this.sessionids.get(identifier);
            return (T)service;
        }
        if (cls.isAssignableFrom(StatefulKnowledgeSession.class)) {
            Object o;
            if (logger.isDebugEnabled()) {
                logger.debug(" ### GridNodeImpl(" + this + "): Resolving StatefulKnowledgeSession.class with ID: " + identifier + ")");
            }
            if (logger.isTraceEnabled()) {
                logger.trace(" ### GridNodeImpl: \t localContext KeySet: " + this.localContext.keySet() + ")");
                logger.trace(" ### GridNodeImpl: \t sessions KeySet: " + this.sessionids.keySet() + ")");
                logger.trace(" ### GridNodeImpl: \t reversesessionids KeySet: " + this.reversesessionids.keySet() + ")");
                logger.trace(" ### GridNodeImpl: \t sessions values: " + this.sessionids.values() + ")");
                logger.trace(" ### GridNodeImpl: \t reverse sessions values: " + this.reversesessionids.values() + ")");
            }
            if ((o = this.localContext.get(identifier)) != null) {
                service = o;
            }
            if (service == null) {
                String sessionId = this.reversesessionids.get(identifier);
                if (logger.isDebugEnabled()) {
                    logger.debug(" ### GridNodeImpl(" + this + "): Resolving StatefulKnowledgeSession.class with reverse ID: " + identifier + " - Found: -> " + sessionId + ")");
                }
                if (sessionId != null && (o = this.localContext.get(sessionId)) != null) {
                    service = o;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug(" ### GridNodeImpl(" + this + "): Resolving StatefulKnowledgeSession.class with ID: " + identifier + " - Instance Found: " + service + " )");
            }
            if (service != null) {
                return (T)service;
            }
        }
        if ((service = this.localContext.get(identifier)) == null) {
            service = this.serviceRegistry.get(cls);
        }
        return (T)service;
    }

    @Override
    public <T> T get(Class<T> serviceClass) {
        return this.get(serviceClass.getName(), serviceClass);
    }

    @Override
    public void set(String identifier, Object object) {
        if (object instanceof StatefulKnowledgeSession) {
            String instanceId = "";
            if (logger.isDebugEnabled()) {
                logger.debug(" ### GridNodeImpl(" + this + "): Registering session: " + object);
            }
            if (object instanceof StatefulKnowledgeSessionRemoteClient) {
                throw new IllegalStateException("I'm registering a remote client!!!");
            }
            if (object instanceof StatefulKnowledgeSessionImpl) {
                instanceId = UUID.randomUUID().toString();
            }
            StatefulKnowledgeSession ksession = (StatefulKnowledgeSession)object;
            if (logger.isDebugEnabled()) {
                logger.debug(" ### GridNodeImpl(" + this + "): Registering  (" + this.id + ") id: " + identifier + " (reverse - clientSessionId: " + instanceId + ") - SFKS: " + ksession);
            }
            this.sessionids.put(identifier, instanceId);
            this.reversesessionids.put(instanceId, identifier);
            this.localContext.put(identifier, ksession);
            return;
        }
        this.localContext.put(identifier, object);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void init(Object context) {
    }

    @Override
    public MessageReceiverHandler getMessageReceiverHandler() {
        return new GridNodeServer(this, new NodeData());
    }

    @Override
    public void registerSocketService(Grid grid, String id, String ip, int port) {
        WhitePages wp = grid.get(WhitePages.class);
        GridServiceDescription gsd = wp.lookup(id);
        if (gsd == null) {
            gsd = wp.create(id);
        }
        gsd.setServiceInterface(GridNode.class);
        gsd.addAddress("socket").setObject(new InetSocketAddress(ip, port));
    }
}

