/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.command.Context;
import org.drools.command.ResolvingKnowledgeCommandContext;
import org.drools.command.impl.ContextImpl;
import org.drools.command.impl.GenericCommand;
import org.drools.grid.GridNode;
import org.drools.grid.io.Conversation;
import org.drools.grid.io.Message;
import org.drools.grid.io.MessageReceiverHandler;
import org.drools.grid.io.impl.CommandImpl;
import org.drools.grid.io.impl.NodeData;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.impl.ExecutionResultImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridNodeServer
implements MessageReceiverHandler {
    private GridNode gnode;
    private NodeData data;
    private Map<String, String> sessions = new HashMap<String, String>();
    private Map<String, String> clientSessions = new HashMap<String, String>();
    private Map<String, String> internalSessionsExposed = new HashMap<String, String>();
    private static Logger logger = LoggerFactory.getLogger(GridNodeServer.class);
    private Map<String, Exec> execs = new HashMap<String, Exec>(){
        {
            this.put("execute", new Exec(){

                public void execute(Object object, Conversation con, Message msg, CommandImpl cmd) {
                    String instanceId;
                    GridNode gnode = (GridNode)object;
                    List<Object> list = cmd.getArguments();
                    GenericCommand command = (GenericCommand)list.get(0);
                    ContextImpl localSessionContext = new ContextImpl("session_" + cmd.getName(), GridNodeServer.this.data.getContextManager(), GridNodeServer.this.data.getTemp());
                    ExecutionResultImpl localKresults = new ExecutionResultImpl();
                    localSessionContext.set("kresults_" + cmd.getName(), (Object)localKresults);
                    if (!(list.size() <= 1 || (instanceId = (String)list.get(1)) == null && instanceId.equals(""))) {
                        String sessionName;
                        if (logger.isDebugEnabled()) {
                            logger.debug(" ### GridNodeServer(execute): Looking for id: =" + instanceId + " inside gnode");
                        }
                        if (logger.isTraceEnabled()) {
                            logger.trace(" ### GridNodeServer(execute): sessions mappings: =" + GridNodeServer.this.sessions.keySet());
                            logger.trace(" ### GridNodeServer(execute): client sessions mappings: =" + GridNodeServer.this.clientSessions.keySet());
                            logger.trace(" ### GridNodeServer(execute): internal sessions exposed mappings: =" + GridNodeServer.this.internalSessionsExposed.keySet());
                            logger.trace(" ### GridNodeServer(execute): sessions mappings values: =" + GridNodeServer.this.sessions.values());
                            logger.trace(" ### GridNodeServer(execute): client sessions mappings values: =" + GridNodeServer.this.clientSessions.values());
                            logger.trace(" ### GridNodeServer(execute): internal sessions exposed mappings values: =" + GridNodeServer.this.internalSessionsExposed.values());
                        }
                        if ((sessionName = (String)GridNodeServer.this.clientSessions.get(instanceId)) == null || sessionName.equals("")) {
                            sessionName = (String)GridNodeServer.this.internalSessionsExposed.get(instanceId);
                        }
                        StatefulKnowledgeSession ksession = gnode.get(sessionName, StatefulKnowledgeSession.class);
                        if (logger.isDebugEnabled()) {
                            logger.debug(" ### GridNodeServer(execute): Looking for id: =" + instanceId + " inside (sessionName = " + sessionName + ")cached client sessions - result: " + ksession);
                        }
                        if (ksession != null) {
                            localSessionContext.set(instanceId, (Object)ksession);
                        }
                    }
                    ResolvingKnowledgeCommandContext resolvingContext = new ResolvingKnowledgeCommandContext((Context)localSessionContext);
                    if (logger.isTraceEnabled()) {
                        logger.trace(" ### GridNodeServer (execute): " + command);
                    }
                    Object result = command.execute((Context)resolvingContext);
                    con.respond(result);
                }
            });
            this.put("registerKsession", new Exec(){

                public void execute(Object object, Conversation con, Message msg, CommandImpl cmd) {
                    GridNode gnode = (GridNode)object;
                    List<Object> list = cmd.getArguments();
                    String sessionName = (String)list.get(0);
                    String clientInstanceId = (String)list.get(1);
                    if (logger.isDebugEnabled()) {
                        logger.debug(" ### GridNodeServer (registerKsession):  registering into GNODE - sessionName: (" + sessionName + ") - instanceId : " + clientInstanceId);
                    }
                    gnode.set(sessionName, GridNodeServer.this.data.getTemp().get(clientInstanceId));
                    if (logger.isDebugEnabled()) {
                        logger.debug(" ### GridNodeServer (registerKsession):  param: (" + clientInstanceId + ") - resolve from node String.class : " + gnode.get(sessionName, String.class));
                    }
                    GridNodeServer.this.sessions.put(sessionName, gnode.get(sessionName, String.class));
                    GridNodeServer.this.clientSessions.put(clientInstanceId, sessionName);
                    if (logger.isTraceEnabled()) {
                        logger.trace(" ### GridNodeServer (registerKsession): clientSession Entry [ " + clientInstanceId + " , " + sessionName + " ]");
                        logger.trace(" ### GridNodeServer (registerKsession): sessions Entry [ " + sessionName + " , " + clientInstanceId + " ]");
                    }
                    con.respond(null);
                }
            });
            this.put("lookupKsession", new Exec(){

                public void execute(Object object, Conversation con, Message msg, CommandImpl cmd) {
                    String clientSessionId;
                    GridNode gnode = (GridNode)object;
                    List<Object> list = cmd.getArguments();
                    String sessionName = (String)list.get(0);
                    if (logger.isDebugEnabled()) {
                        logger.debug("(" + Thread.currentThread().getId() + ")" + Thread.currentThread().getName() + " ### GridNodeServer (lookupKsession):  node: (" + gnode.getId() + ") - sessionname: (" + sessionName + ")");
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("(" + Thread.currentThread().getId() + ")" + Thread.currentThread().getName() + " ### GridNodeServer (lookupKsession):  \t available client sessions: " + GridNodeServer.this.clientSessions.keySet());
                        logger.trace("(" + Thread.currentThread().getId() + ")" + Thread.currentThread().getName() + " ### GridNodeServer (lookupKsession):  \t available cached sessions: " + GridNodeServer.this.sessions.keySet());
                    }
                    if ((clientSessionId = (String)GridNodeServer.this.clientSessions.get(sessionName)) == null || clientSessionId.equals("")) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("(" + Thread.currentThread().getId() + ")" + Thread.currentThread().getName() + " ### GridNodeServer (lookupKsession): The session is in the local context: " + gnode.get(sessionName, String.class));
                            logger.debug(" ### GridNodeServer (lookupKsession): I'm inside the node =" + gnode.getId() + " instance: " + gnode);
                        }
                        clientSessionId = gnode.get(sessionName, String.class);
                        if (logger.isDebugEnabled()) {
                            logger.debug("(" + Thread.currentThread().getId() + ")" + Thread.currentThread().getName() + " ### GridNodeServer (lookupKsession): Registering internal Session Id into internalSessionExposed with sessionId: =" + clientSessionId + " for session name: " + sessionName);
                        }
                        GridNodeServer.this.internalSessionsExposed.put(clientSessionId, sessionName);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("(" + Thread.currentThread().getId() + ")" + Thread.currentThread().getName() + " ### GridNodeServer (lookupKsession):  return =" + clientSessionId);
                    }
                    con.respond(clientSessionId);
                }
            });
            this.put("lookupKsessionId", new Exec(){

                public void execute(Object object, Conversation con, Message msg, CommandImpl cmd) {
                    GridNode gnode = (GridNode)object;
                    List<Object> list = cmd.getArguments();
                    String sessionId = (String)list.get(0);
                    logger.debug(" ### GridNodeServer (lookupKsessionId): SessionID???????: " + sessionId);
                    String gnodeInternalSessionId = (String)GridNodeServer.this.clientSessions.get(sessionId);
                    if (logger.isDebugEnabled()) {
                        logger.debug(" ### GridNodeServer (lookupKsessionId): Available Client Sessions: " + GridNodeServer.this.clientSessions);
                        logger.debug(" ### GridNodeServer (lookupKsessionId): Available Sessions: " + GridNodeServer.this.sessions);
                        logger.debug(" ### GridNodeServer (lookupKsessionId): Instance Id Found inside gnode: (" + gnode.getId() + ") for session (" + sessionId + ") - " + gnodeInternalSessionId);
                    }
                    if (gnodeInternalSessionId == null || gnodeInternalSessionId.equals("")) {
                        for (String key : GridNodeServer.this.clientSessions.keySet()) {
                            if (!((String)GridNodeServer.this.clientSessions.get(key)).equals(sessionId)) continue;
                            gnodeInternalSessionId = key;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug(" ### GridNodeServer (lookupKsessionId): gnodeInternalSessionId found using reverse lookup: " + gnodeInternalSessionId);
                        }
                    }
                    if (gnodeInternalSessionId == null || gnodeInternalSessionId.equals("")) {
                        for (String key : GridNodeServer.this.internalSessionsExposed.keySet()) {
                            if (!((String)GridNodeServer.this.internalSessionsExposed.get(key)).equals(sessionId)) continue;
                            gnodeInternalSessionId = key;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug(" ### GridNodeServer (lookupKsessionId): gnodeInternalSessionId found using reverse lookup in internalSessionExposed: " + gnodeInternalSessionId);
                        }
                    }
                    if (gnodeInternalSessionId == null || gnodeInternalSessionId.equals("")) {
                        if (logger.isDebugEnabled()) {
                            logger.debug(" ### GridNodeServer (lookupKsessionId): The session is in the local context: " + gnode.get(sessionId, String.class));
                            logger.debug(" ### GridNodeServer (lookupKsessionId): I'm inside the node =" + gnode.getId() + " instance: " + gnode);
                        }
                        gnodeInternalSessionId = gnode.get(sessionId, String.class);
                        GridNodeServer.this.sessions.put(sessionId, gnodeInternalSessionId);
                    }
                    con.respond(gnodeInternalSessionId);
                }
            });
        }
    };

    public GridNodeServer(GridNode gnode, NodeData data) {
        if (logger.isDebugEnabled()) {
            logger.debug(" ### GridNodeServer: Creating GridNodeServer for node: " + gnode.getId());
        }
        this.gnode = gnode;
        this.data = data;
    }

    public void messageReceived(Conversation conversation, Message msg) {
        CommandImpl cmd = (CommandImpl)msg.getBody();
        this.execs.get(cmd.getName()).execute(this.gnode, conversation, msg, cmd);
    }

    public NodeData getData() {
        return this.data;
    }

    public static interface Exec {
        public void execute(Object var1, Conversation var2, Message var3, CommandImpl var4);
    }
}

