/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.remote.mina;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.transport.socket.SocketConnector;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.drools.SystemEventListener;
import org.drools.grid.io.Connector;
import org.drools.grid.io.IoWriter;
import org.drools.grid.io.MessageReceiverHandler;
import org.drools.grid.remote.mina.MinaIoHandler;
import org.drools.grid.remote.mina.MinaIoWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinaConnector
implements Connector {
    private static Logger logger = LoggerFactory.getLogger(MinaConnector.class);
    protected MinaIoWriter writer;
    protected SocketConnector connector;

    public synchronized void setConnector(SocketConnector connector) {
        this.connector = connector;
    }

    public synchronized IoWriter open(InetSocketAddress address, MessageReceiverHandler handler, SystemEventListener systemEventListener) {
        if (this.writer != null && this.writer.getIoSession().isConnected()) {
            throw new IllegalStateException("Already connected. Disconnect first.");
        }
        this.writer = null;
        if (address == null) {
            throw new IllegalArgumentException("Address cannot be null");
        }
        if (this.connector == null) {
            this.connector = new NioSocketConnector();
            this.connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new ObjectSerializationCodecFactory()));
        }
        this.connector.setHandler((IoHandler)new MinaIoHandler(systemEventListener, handler));
        if (logger.isTraceEnabled()) {
            logger.trace(" ### Connecting with " + address.getHostName() + ":" + address.getPort());
        }
        ConnectFuture future1 = this.connector.connect((SocketAddress)address);
        future1.awaitUninterruptibly();
        if (!future1.isConnected()) {
            throw new IllegalStateException("Unnable to connect to " + address);
        }
        IoSession session = future1.getSession();
        this.writer = new MinaIoWriter(session);
        return this.writer;
    }

    public synchronized void close() {
        if (this.writer != null) {
            IoSession session = this.writer.getIoSession();
            if (session != null && session.isConnected()) {
                session.close(false).awaitUninterruptibly();
            }
            this.writer.dispose();
            this.writer = null;
        }
        if (this.connector != null && this.connector.isActive()) {
            this.connector.dispose();
            this.connector = null;
        }
    }

    public synchronized boolean isOpen() {
        IoSession session;
        return this.writer != null && (session = this.writer.getIoSession()) != null && session.isConnected();
    }
}

