/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Message;
import org.apache.camel.converter.jaxb.HeaderDefinition;
import org.apache.camel.converter.jaxb.IntegerHeader;
import org.apache.camel.converter.jaxb.LongHeader;
import org.apache.camel.converter.jaxb.StringHeader;
import org.apache.camel.util.CastUtils;

@XmlRootElement(name="message")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MessageDefinition {
    @XmlAnyElement(lax=true)
    @XmlMixed
    List<HeaderDefinition> headers = new ArrayList<HeaderDefinition>();
    @XmlAnyElement(lax=true)
    @XmlMixed
    private List<Object> content = new ArrayList<Object>();
    @XmlTransient
    private Object body;

    public Object getBody() {
        if (this.body == null && this.content != null) {
            if (this.content.size() == 1) {
                return this.content.get(0);
            }
            return this.content;
        }
        return this.body;
    }

    public void setBody(Object body) {
        this.body = body;
        if (body instanceof List) {
            List cont;
            this.content = cont = CastUtils.cast((List)((List)body));
        } else {
            this.content = new ArrayList<Object>();
            this.content.add(body);
        }
    }

    public List<HeaderDefinition> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<HeaderDefinition> headers) {
        this.headers = headers;
    }

    public Map<String, Object> getHeaderMap() {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        for (HeaderDefinition header : this.headers) {
            answer.put(header.getName(), header.getValue());
        }
        return answer;
    }

    public void copyFrom(Message message) {
        this.headers.clear();
        Set entries = message.getHeaders().entrySet();
        for (Map.Entry entry : entries) {
            Object value = entry.getValue();
            if (value == null) continue;
            this.headers.add(this.createHeader((String)entry.getKey(), value));
        }
        this.setBody(message.getBody());
    }

    public void copyTo(Message message) {
        message.setHeaders(this.getHeaderMap());
        message.setBody(this.getBody());
    }

    protected HeaderDefinition createHeader(String key, Object value) {
        if (value instanceof String) {
            return new StringHeader(key, (String)value);
        }
        if (value instanceof Integer) {
            return new IntegerHeader(key, (Integer)value);
        }
        if (value instanceof Long) {
            return new LongHeader(key, (Long)value);
        }
        return new StringHeader(key, value.toString());
    }
}

