/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.ascii.memcache;

import com.hazelcast.impl.ascii.AbstractTextCommand;
import com.hazelcast.impl.ascii.TextCommandConstants;
import com.hazelcast.nio.IOUtil;
import java.nio.ByteBuffer;

public class GetCommand
extends AbstractTextCommand {
    final String key;
    ByteBuffer header;
    ByteBuffer value;
    ByteBuffer lastOne;

    public GetCommand(TextCommandConstants.TextCommandType type, String key) {
        super(type);
        this.key = key;
    }

    public GetCommand(String key) {
        this(TextCommandConstants.TextCommandType.GET, key);
    }

    public String getKey() {
        return this.key;
    }

    public boolean doRead(ByteBuffer cb) {
        return true;
    }

    public void setValue(byte[] value, boolean singleGet) {
        if (value == null) {
            if (singleGet) {
                this.lastOne = ByteBuffer.wrap(END);
            }
            return;
        }
        this.lastOne = ByteBuffer.wrap(singleGet ? RETURN_END : RETURN);
        this.value = ByteBuffer.wrap(value);
        int valueLenInt = value.length;
        byte[] valueLen = String.valueOf(valueLenInt).getBytes();
        byte[] keyBytes = this.key.getBytes();
        int headerSize = VALUE_SPACE.length + keyBytes.length + FLAG_ZERO.length + valueLen.length + RETURN.length;
        this.header = ByteBuffer.allocate(headerSize);
        this.header.put(VALUE_SPACE);
        this.header.put(keyBytes);
        this.header.put(FLAG_ZERO);
        this.header.put(valueLen);
        this.header.put(RETURN);
        this.header.flip();
    }

    public boolean writeTo(ByteBuffer bb) {
        IOUtil.copyToHeapBuffer(this.header, bb);
        IOUtil.copyToHeapBuffer(this.value, bb);
        IOUtil.copyToHeapBuffer(this.lastOne, bb);
        return !(this.header != null && this.header.hasRemaining() || this.value != null && this.value.hasRemaining() || this.lastOne != null && this.lastOne.hasRemaining());
    }

    public String toString() {
        return "GetCommand{key='" + this.key + '\'' + '}' + super.toString();
    }
}

