/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.index.tree;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.kaha.Marshaller;

class TreeEntry
implements Comparable {
    static final int NOT_SET = -1;
    private Comparable key;
    private long indexOffset;
    private long prevPageId = -1L;
    private long nextPageId = -1L;

    TreeEntry() {
    }

    public int compareTo(Object o) {
        if (o instanceof TreeEntry) {
            TreeEntry other = (TreeEntry)o;
            return this.key.compareTo(other.key);
        }
        return this.key.compareTo(o);
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return "TreeEntry(" + this.key + "," + this.indexOffset + ")prev=" + this.prevPageId + ",next=" + this.nextPageId;
    }

    void reset() {
        this.prevPageId = -1L;
        this.nextPageId = -1L;
    }

    TreeEntry copy() {
        TreeEntry copy = new TreeEntry();
        copy.key = this.key;
        copy.indexOffset = this.indexOffset;
        copy.prevPageId = this.prevPageId;
        copy.nextPageId = this.nextPageId;
        return copy;
    }

    Comparable getKey() {
        return this.key;
    }

    void setKey(Comparable key) {
        this.key = key;
    }

    long getNextPageId() {
        return this.nextPageId;
    }

    void setNextPageId(long nextPageId) {
        this.nextPageId = nextPageId;
    }

    long getPrevPageId() {
        return this.prevPageId;
    }

    void setPrevPageId(long prevPageId) {
        this.prevPageId = prevPageId;
    }

    long getIndexOffset() {
        return this.indexOffset;
    }

    void setIndexOffset(long indexOffset) {
        this.indexOffset = indexOffset;
    }

    boolean hasChildPagesReferences() {
        return this.prevPageId != -1L || this.nextPageId != -1L;
    }

    void write(Marshaller keyMarshaller, DataOutput dataOut) throws IOException {
        keyMarshaller.writePayload(this.key, dataOut);
        dataOut.writeLong(this.indexOffset);
        dataOut.writeLong(this.nextPageId);
        dataOut.writeLong(this.prevPageId);
    }

    void read(Marshaller keyMarshaller, DataInput dataIn) throws IOException {
        this.key = (Comparable)keyMarshaller.readPayload(dataIn);
        this.indexOffset = dataIn.readLong();
        this.nextPageId = dataIn.readLong();
        this.prevPageId = dataIn.readLong();
    }
}

