/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.descr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.AnnotatedBaseDescr;
import org.drools.lang.descr.AttributeDescr;
import org.drools.rule.Dialectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleDescr
extends AnnotatedBaseDescr
implements Dialectable {
    private static final long serialVersionUID = 510L;
    private String name;
    private String parentName;
    private String documentation;
    private Map<String, AttributeDescr> attributes;
    private AndDescr lhs;
    private Object consequence;
    private Map<String, Object> namedConsequence;
    private int consequenceLine;
    private int consequencePattern;
    private int offset;
    private String className;

    public RuleDescr() {
        this(null, "");
    }

    public RuleDescr(String name) {
        this(name, "");
    }

    public RuleDescr(String ruleName, String documentation) {
        this.name = ruleName;
        this.documentation = documentation;
        this.attributes = new LinkedHashMap<String, AttributeDescr>();
        this.namedConsequence = new HashMap<String, Object>();
        this.lhs = new AndDescr();
        this.consequence = "";
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.name = (String)in.readObject();
        this.parentName = (String)in.readObject();
        this.documentation = (String)in.readObject();
        this.consequence = in.readObject();
        this.namedConsequence = (Map)in.readObject();
        this.lhs = (AndDescr)in.readObject();
        this.consequenceLine = in.readInt();
        this.consequencePattern = in.readInt();
        this.offset = in.readInt();
        this.attributes = (Map)in.readObject();
        this.className = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.name);
        out.writeObject(this.parentName);
        out.writeObject(this.documentation);
        out.writeObject(this.consequence);
        out.writeObject(this.namedConsequence);
        out.writeObject(this.lhs);
        out.writeInt(this.consequenceLine);
        out.writeInt(this.consequencePattern);
        out.writeInt(this.offset);
        out.writeObject(this.attributes);
        out.writeObject(this.className);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDialect() {
        AttributeDescr dialect = this.attributes.get("dialect");
        return dialect != null ? dialect.getValue() : null;
    }

    public String getSalience() {
        AttributeDescr salience = this.attributes.get("salience");
        return salience != null ? salience.getValue() : null;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public Map<String, AttributeDescr> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(AttributeDescr attribute) {
        if (attribute != null) {
            this.attributes.put(attribute.getName(), attribute);
        }
    }

    public AndDescr getLhs() {
        return this.lhs;
    }

    public void setLhs(AndDescr lhs) {
        this.lhs = lhs;
    }

    public Object getConsequence() {
        return this.consequence;
    }

    public void setConsequence(Object consequence) {
        this.consequence = consequence;
    }

    public Map<String, Object> getNamedConsequences() {
        return this.namedConsequence;
    }

    public void setConsequenceLocation(int line, int pattern) {
        this.consequenceLine = line;
        this.consequencePattern = pattern;
    }

    public void setConsequenceOffset(int offset) {
        this.offset = offset;
    }

    public int getConsequenceOffset() {
        return this.offset;
    }

    public int getConsequenceLine() {
        return this.consequenceLine;
    }

    public int getConsequencePattern() {
        return this.consequencePattern;
    }

    public String getEnabled() {
        AttributeDescr enabled = this.attributes.get("enabled");
        return enabled != null ? enabled.getValue() : null;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public String getParentName() {
        return this.parentName;
    }

    public boolean isRule() {
        return true;
    }

    public boolean isQuery() {
        return false;
    }

    public String toString() {
        return "[Rule name='" + this.name + "']";
    }
}

