/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Set;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.blueprint.BlueprintCamelContext;
import org.apache.camel.spi.PackageScanClassResolver;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageScanRouteBuilderFinder {
    private static final transient Logger LOG = LoggerFactory.getLogger(PackageScanRouteBuilderFinder.class);
    private final BlueprintCamelContext camelContext;
    private final String[] packages;
    private final PackageScanClassResolver resolver;
    private final BlueprintContainer blueprintContainer;

    public PackageScanRouteBuilderFinder(BlueprintCamelContext camelContext, String[] packages, ClassLoader classLoader, PackageScanClassResolver resolver) {
        this.camelContext = camelContext;
        this.blueprintContainer = camelContext.getBlueprintContainer();
        this.packages = packages;
        this.resolver = resolver;
        resolver.addClassLoader(classLoader);
    }

    public void appendBuilders(List<RoutesBuilder> list) throws IllegalAccessException, InstantiationException {
        Set classes = this.resolver.findImplementations(RoutesBuilder.class, this.packages);
        for (Class aClass : classes) {
            LOG.trace("Found RouteBuilder class: {}", (Object)aClass);
            if (this.shouldIgnoreBean(aClass)) {
                LOG.debug("Ignoring RouteBuilder class: {}", (Object)aClass);
                continue;
            }
            if (!this.isValidClass(aClass)) {
                LOG.debug("Ignoring invalid RouteBuilder class: {}", (Object)aClass);
                continue;
            }
            RoutesBuilder builder = this.instantiateBuilder(aClass);
            LOG.debug("Adding instantiated RouteBuilder: {}", (Object)builder);
            list.add(builder);
        }
    }

    protected boolean shouldIgnoreBean(Class<?> type) {
        for (Object metadataObject : this.blueprintContainer.getMetadata(BeanMetadata.class)) {
            Object bean;
            BeanMetadata metadata = (BeanMetadata)metadataObject;
            if (!"singleton".equals(metadata.getScope()) || !type.isInstance(bean = this.blueprintContainer.getComponentInstance(metadata.getId()))) continue;
            return true;
        }
        return false;
    }

    protected boolean isValidClass(Class type) {
        return !Modifier.isAbstract(type.getModifiers()) && !type.isInterface();
    }

    protected RoutesBuilder instantiateBuilder(Class type) throws IllegalAccessException, InstantiationException {
        return (RoutesBuilder)this.camelContext.getInjector().newInstance(type);
    }
}

