/*
 * Copyright 2011 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.fluent.test.impl;

import static org.junit.Assert.fail;

import java.util.HashMap;
import java.util.Map;

import org.drools.command.Context;
import org.drools.command.impl.GenericCommand;
import org.drools.fluent.test.ReflectiveMatcherAssert;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;

public class ReflectiveMatcherAssertCommand  implements GenericCommand<Void>  {

    private ReflectiveMatcherAssert matcherAssert;
    
    public ReflectiveMatcherAssertCommand() {
        
    }
    
    public ReflectiveMatcherAssertCommand(ReflectiveMatcherAssert matcherAssert) {
        this.matcherAssert = matcherAssert;
    }

    
    public ReflectiveMatcherAssert getMatcherAssert() {
        return matcherAssert;
    }

    public void setMatcherAssert(ReflectiveMatcherAssert matcherAssert) {
        this.matcherAssert = matcherAssert;
    }

    public Void execute(Context context) {
        matcherAssert.eval( context );        
        return null;
    }

}
