/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.IOException;
import org.drools.Agenda;
import org.drools.common.AgendaItem;
import org.drools.common.DefaultAgenda;
import org.drools.common.InternalAgenda;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.ScheduledAgendaItem;
import org.drools.marshalling.impl.InputMarshaller;
import org.drools.marshalling.impl.MarshallerReaderContext;
import org.drools.marshalling.impl.MarshallerWriteContext;
import org.drools.marshalling.impl.OutputMarshaller;
import org.drools.marshalling.impl.PersisterHelper;
import org.drools.marshalling.impl.ProtobufInputMarshaller;
import org.drools.marshalling.impl.ProtobufMessages;
import org.drools.marshalling.impl.ProtobufOutputMarshaller;
import org.drools.marshalling.impl.TimersInputMarshaller;
import org.drools.marshalling.impl.TimersOutputMarshaller;
import org.drools.reteoo.LeftTuple;
import org.drools.time.Job;
import org.drools.time.JobContext;
import org.drools.time.JobHandle;
import org.drools.time.Trigger;

public final class Scheduler {
    private Scheduler() {
    }

    public static void scheduleAgendaItem(ScheduledAgendaItem item, InternalAgenda agenda, InternalWorkingMemory wm) {
        Trigger trigger = item.getRule().getTimer().createTrigger(item, wm);
        ActivationTimerJob job = new ActivationTimerJob();
        ActivationTimerJobContext ctx = new ActivationTimerJobContext(trigger, item, agenda);
        JobHandle jobHandle = ((InternalWorkingMemory)agenda.getWorkingMemory()).getTimerService().scheduleJob(job, ctx, trigger);
        item.setJobHandle(jobHandle);
    }

    public static void removeAgendaItem(ScheduledAgendaItem item, InternalAgenda agenda) {
        ((InternalWorkingMemory)agenda.getWorkingMemory()).getTimerService().removeJob(item.getJobHandle());
    }

    public static class ActivationTimerInputMarshaller
    implements TimersInputMarshaller {
        public void read(MarshallerReaderContext inCtx) throws IOException, ClassNotFoundException {
            int leftTupleId = inCtx.readInt();
            LeftTuple leftTuple = inCtx.terminalTupleMap.get(leftTupleId);
            ScheduledAgendaItem item = (ScheduledAgendaItem)leftTuple.getObject();
            Trigger trigger = InputMarshaller.readTrigger(inCtx);
            DefaultAgenda agenda = (DefaultAgenda)inCtx.wm.getAgenda();
            ActivationTimerJob job = new ActivationTimerJob();
            ActivationTimerJobContext ctx = new ActivationTimerJobContext(trigger, item, agenda);
            JobHandle jobHandle = ((InternalWorkingMemory)agenda.getWorkingMemory()).getTimerService().scheduleJob(job, ctx, trigger);
            item.setJobHandle(jobHandle);
        }

        public void deserialize(MarshallerReaderContext inCtx, ProtobufMessages.Timers.Timer _timer) throws ClassNotFoundException {
            ProtobufMessages.Timers.ActivationTimer _activation = _timer.getActivation();
            LeftTuple leftTuple = inCtx.filter.getTuplesCache().get(PersisterHelper.createActivationKey(_activation.getActivation().getPackageName(), _activation.getActivation().getRuleName(), _activation.getActivation().getTuple()));
            ScheduledAgendaItem item = (ScheduledAgendaItem)leftTuple.getObject();
            Trigger trigger = ProtobufInputMarshaller.readTrigger(inCtx, _activation.getTrigger());
            DefaultAgenda agenda = (DefaultAgenda)inCtx.wm.getAgenda();
            ActivationTimerJob job = new ActivationTimerJob();
            ActivationTimerJobContext ctx = new ActivationTimerJobContext(trigger, item, agenda);
            JobHandle jobHandle = ((InternalWorkingMemory)agenda.getWorkingMemory()).getTimerService().scheduleJob(job, ctx, trigger);
            item.setJobHandle(jobHandle);
        }
    }

    public static class ActivationTimerOutputMarshaller
    implements TimersOutputMarshaller {
        public void write(JobContext jobCtx, MarshallerWriteContext outputCtx) throws IOException {
            outputCtx.writeShort(52);
            ActivationTimerJobContext ajobCtx = (ActivationTimerJobContext)jobCtx;
            int leftTupleId = outputCtx.terminalTupleMap.get(ajobCtx.getScheduledAgendaItem().getTuple());
            outputCtx.writeInt(leftTupleId);
            OutputMarshaller.writeTrigger(ajobCtx.getTrigger(), outputCtx);
        }

        public ProtobufMessages.Timers.Timer serialize(JobContext jobCtx, MarshallerWriteContext outputCtx) {
            ActivationTimerJobContext ajobCtx = (ActivationTimerJobContext)jobCtx;
            return ProtobufMessages.Timers.Timer.newBuilder().setType(ProtobufMessages.Timers.TimerType.ACTIVATION).setActivation(ProtobufMessages.Timers.ActivationTimer.newBuilder().setActivation(PersisterHelper.createActivation(ajobCtx.getScheduledAgendaItem().getRule().getPackageName(), ajobCtx.getScheduledAgendaItem().getRule().getName(), ajobCtx.getScheduledAgendaItem().getTuple())).setTrigger(ProtobufOutputMarshaller.writeTrigger(ajobCtx.getTrigger(), outputCtx)).build()).build();
        }
    }

    public static class ActivationTimerJobContext
    implements JobContext {
        private JobHandle jobHandle;
        private ScheduledAgendaItem scheduledAgendaItem;
        private Agenda agenda;
        private Trigger trigger;

        public ActivationTimerJobContext(Trigger trigger, ScheduledAgendaItem scheduledAgendaItem, Agenda agenda) {
            this.trigger = trigger;
            this.scheduledAgendaItem = scheduledAgendaItem;
            this.agenda = agenda;
        }

        public Agenda getAgenda() {
            return this.agenda;
        }

        public ScheduledAgendaItem getScheduledAgendaItem() {
            return this.scheduledAgendaItem;
        }

        public JobHandle getJobHandle() {
            return this.jobHandle;
        }

        public void setJobHandle(JobHandle jobHandle) {
            this.jobHandle = jobHandle;
        }

        public Trigger getTrigger() {
            return this.trigger;
        }

        public void setScheduledAgendaItem(ScheduledAgendaItem scheduledAgendaItem) {
            this.scheduledAgendaItem = scheduledAgendaItem;
        }

        public void setAgenda(Agenda agenda) {
            this.agenda = agenda;
        }

        public void setTrigger(Trigger trigger) {
            this.trigger = trigger;
        }
    }

    public static class ActivationTimerJob
    implements Job {
        public void execute(JobContext ctx) {
            InternalAgenda agenda = (InternalAgenda)((ActivationTimerJobContext)ctx).getAgenda();
            ScheduledAgendaItem item = ((ActivationTimerJobContext)ctx).getScheduledAgendaItem();
            boolean wasFired = agenda.fireTimedActivation(item, false);
            if (((ActivationTimerJobContext)ctx).getTrigger().hasNextFireTime() == null) {
                if (wasFired) {
                    agenda.getWorkingMemory().fireAllRules();
                } else {
                    this.postpone(item, agenda);
                }
                if (item.isEnqueued()) {
                    agenda.getScheduledActivationsLinkedList().remove(item);
                    item.setEnqueued(false);
                }
            } else {
                item.setActivated(true);
                if (wasFired) {
                    agenda.getWorkingMemory().fireAllRules();
                } else {
                    this.postpone(item, agenda);
                }
            }
        }

        private void postpone(ScheduledAgendaItem item, InternalAgenda agenda) {
            LeftTuple postponedTuple;
            if (item.getTuple().getParent() != null) {
                postponedTuple = item.getRuleTerminalNode().createLeftTuple(item.getTuple().getParent(), item.getTuple().getSink(), false);
                item.getTuple().getLeftParent().setLastChild(postponedTuple);
                item.getTuple().getRightParent().getFactHandle().addLastLeftTuple(postponedTuple);
            } else {
                postponedTuple = item.getRuleTerminalNode().createLeftTuple(item.getTuple().getHandle(), item.getTuple().getSink(), false);
                item.getTuple().getHandle().addLastLeftTuple(postponedTuple);
            }
            ((DefaultAgenda)agenda).createPostponedActivation(postponedTuple, item.getPropagationContext(), (InternalWorkingMemory)agenda.getWorkingMemory(), item.getRuleTerminalNode());
            agenda.addActivation((AgendaItem)postponedTuple.getObject());
        }
    }
}

