/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.drools.type.DateFormats;

public class DateUtils {
    private static final long serialVersionUID = 510L;
    private static final String DEFAULT_FORMAT_MASK = "dd-MMM-yyyy";
    private static final String DATE_FORMAT_MASK = DateUtils.getDateFormatMask();
    private static final String DEFAULT_COUNTRY = Locale.getDefault().getCountry();
    private static final String DEFINE_COUNTRY = DateUtils.getDefaultContry();
    private static final String DEFAULT_LANGUAGE = Locale.getDefault().getLanguage();
    private static final String DEFINE_LANGUAGE = DateUtils.getDefaultLanguage();
    private static ThreadLocal<SimpleDateFormat> df = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            DateFormatSymbols dateSymbol = new DateFormatSymbols(new Locale(DEFINE_LANGUAGE, DEFINE_COUNTRY));
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_MASK, dateSymbol);
            return dateFormat;
        }
    };

    private static String getDefaultLanguage() {
        String fmt = System.getProperty("drools.defaultlanguage");
        if (fmt == null) {
            fmt = DEFAULT_LANGUAGE;
        }
        return fmt;
    }

    private static String getDefaultContry() {
        String fmt = System.getProperty("drools.defaultcountry");
        if (fmt == null) {
            fmt = DEFAULT_COUNTRY;
        }
        return fmt;
    }

    public static Date parseDate(String input, DateFormats dateFormats) {
        try {
            return df.get().parse(input);
        }
        catch (ParseException e) {
            try {
                return new SimpleDateFormat(DATE_FORMAT_MASK, Locale.UK).parse(input);
            }
            catch (ParseException e1) {
                throw new IllegalArgumentException("Invalid date input format: [" + input + "] it should follow: [" + DATE_FORMAT_MASK + "]");
            }
        }
    }

    public static String format(Date input) {
        return df.get().format(input);
    }

    public static Date getRightDate(Object object2, DateFormats dateFormats) {
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof String) {
            return DateUtils.parseDate((String)object2, dateFormats);
        }
        if (object2 instanceof Date) {
            return (Date)object2;
        }
        throw new IllegalArgumentException("Unable to convert " + object2.getClass() + " to a Date.");
    }

    public static String getDateFormatMask() {
        String fmt = System.getProperty("drools.dateformat");
        if (fmt == null) {
            fmt = DEFAULT_FORMAT_MASK;
        }
        return fmt;
    }
}

