/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.repository;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.milyn.assertion.AssertArgument;
import org.milyn.javabean.repository.BeanId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanIdRegister {
    private int index = 0;
    private final Map<String, BeanId> beanIdMap = new HashMap<String, BeanId>();

    public synchronized BeanId register(String beanIdName) {
        AssertArgument.isNotEmpty((String)beanIdName, (String)"beanIdName");
        BeanId beanId = this.beanIdMap.get(beanIdName);
        if (beanId == null) {
            int id = this.index++;
            beanId = new BeanId(this, id, beanIdName);
            this.beanIdMap.put(beanIdName, beanId);
        }
        return beanId;
    }

    public BeanId getBeanId(String beanId) {
        return this.beanIdMap.get(beanId);
    }

    public boolean containsBeanId(String beanId) {
        return this.beanIdMap.containsKey(beanId);
    }

    public Map<String, BeanId> getBeanIdMap() {
        return Collections.unmodifiableMap(this.beanIdMap);
    }

    public int size() {
        return this.index;
    }
}

