/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.carinsurance.domain.request;

import java.util.ArrayList;
import java.util.List;
import org.drools.examples.carinsurance.domain.Car;
import org.drools.examples.carinsurance.domain.Driver;
import org.drools.examples.carinsurance.domain.request.CoverageRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyRequest {
    private Driver owner;
    private Car car;
    private List<CoverageRequest> coverageRequestList = new ArrayList<CoverageRequest>();
    private boolean automaticallyRejected = false;
    private List<String> rejectedMessageList = new ArrayList<String>();
    private List<String> flaggedMessageList = new ArrayList<String>();
    private boolean requiresManualApproval = false;
    private boolean manuallyApproved = false;

    public PolicyRequest() {
    }

    public PolicyRequest(Driver owner, Car car) {
        this.car = car;
        this.owner = owner;
    }

    public Driver getOwner() {
        return this.owner;
    }

    public void setOwner(Driver owner) {
        this.owner = owner;
    }

    public Car getCar() {
        return this.car;
    }

    public void setCar(Car car) {
        this.car = car;
    }

    public List<CoverageRequest> getCoverageRequestList() {
        return this.coverageRequestList;
    }

    public boolean isAutomaticallyRejected() {
        return this.automaticallyRejected;
    }

    public void setAutomaticallyRejected(boolean automaticallyRejected) {
        this.automaticallyRejected = automaticallyRejected;
    }

    public List<String> getRejectedMessageList() {
        return this.rejectedMessageList;
    }

    public boolean isRequiresManualApproval() {
        return this.requiresManualApproval;
    }

    public void setRequiresManualApproval(boolean requiresManualApproval) {
        this.requiresManualApproval = requiresManualApproval;
    }

    public boolean isManuallyApproved() {
        return this.manuallyApproved;
    }

    public void setManuallyApproved(boolean manuallyApproved) {
        this.manuallyApproved = manuallyApproved;
    }

    public List<String> getFlaggedMessageList() {
        return this.flaggedMessageList;
    }

    public void addCoverageRequest(CoverageRequest coverageRequest) {
        coverageRequest.setPolicyRequest(this);
        this.coverageRequestList.add(coverageRequest);
    }

    public void addRejectedMessage(String rejectedMessage) {
        this.rejectedMessageList.add(rejectedMessage);
    }

    public void addFlaggedMessage(String flaggedMessage) {
        this.flaggedMessageList.add(flaggedMessage);
    }

    public boolean isApproved() {
        return !this.automaticallyRejected && (!this.requiresManualApproval || this.manuallyApproved);
    }
}

