/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.conway;

import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.examples.conway.ConwayRuleDelegate;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;

public class RuleFlowDelegate
implements ConwayRuleDelegate {
    private StatefulKnowledgeSession session;

    public RuleFlowDelegate() {
        try {
            KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            kbuilder.add(ResourceFactory.newClassPathResource("ruleflow/conway-ruleflow.drl", this.getClass()), ResourceType.DRL);
            kbuilder.add(ResourceFactory.newClassPathResource("generation.rf", this.getClass()), ResourceType.DRF);
            kbuilder.add(ResourceFactory.newClassPathResource("killAll.rf", this.getClass()), ResourceType.DRF);
            kbuilder.add(ResourceFactory.newClassPathResource("registerNeighbor.rf", this.getClass()), ResourceType.DRF);
            KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
            kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
            this.session = kbase.newStatefulKnowledgeSession();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public StatefulKnowledgeSession getSession() {
        return this.session;
    }

    public void init() {
        this.session.startProcess("register neighbor");
        this.session.fireAllRules();
        this.session.getAgenda().getRuleFlowGroup("calculate").clear();
    }

    public boolean nextGeneration() {
        this.session.startProcess("generation");
        return this.session.fireAllRules() != 0;
    }

    public void killAll() {
        this.session.startProcess("kill all");
        this.session.fireAllRules();
    }
}

