/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.AbstractRemotelyProcessable;
import com.hazelcast.impl.NodeType;
import com.hazelcast.nio.Address;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class JoinRequest
extends AbstractRemotelyProcessable {
    protected NodeType nodeType = NodeType.MEMBER;
    public Address address;
    public Address to;
    public String groupName;
    public String groupPassword;
    public byte packetVersion;
    public int buildNumber;

    public JoinRequest() {
    }

    public JoinRequest(Address address, String groupName, String groupPassword, NodeType type, byte packetVersion, int buildNumber) {
        this(null, address, groupName, groupPassword, type, packetVersion, buildNumber);
    }

    public JoinRequest(Address to, Address address, String groupName, String groupPassword, NodeType type, byte packetVersion, int buildNumber) {
        this.to = to;
        this.address = address;
        this.groupName = groupName;
        this.groupPassword = groupPassword;
        this.nodeType = type;
        this.packetVersion = packetVersion;
        this.buildNumber = buildNumber;
    }

    public void readData(DataInput in) throws IOException {
        boolean hasTo = in.readBoolean();
        if (hasTo) {
            this.to = new Address();
            this.to.readData(in);
        }
        this.address = new Address();
        this.address.readData(in);
        this.nodeType = NodeType.create(in.readInt());
        this.groupName = in.readUTF();
        this.groupPassword = in.readUTF();
        this.packetVersion = in.readByte();
        this.buildNumber = in.readInt();
    }

    public void writeData(DataOutput out) throws IOException {
        boolean hasTo = this.to != null;
        out.writeBoolean(hasTo);
        if (hasTo) {
            this.to.writeData(out);
        }
        this.address.writeData(out);
        out.writeInt(this.nodeType.getValue());
        out.writeUTF(this.groupName);
        out.writeUTF(this.groupPassword);
        out.writeByte(this.packetVersion);
        out.writeInt(this.buildNumber);
    }

    public String toString() {
        return new StringBuilder(128).append("JoinRequest{").append("nodeType=").append((Object)this.nodeType).append(", address=").append(this.address).append(", groupName='").append(this.groupName).append('\'').append(", groupPassword='").append(this.groupPassword).append('\'').append(", buildNumber='").append(this.buildNumber).append('\'').append(", packetVersion='").append(this.packetVersion).append('\'').append('}').toString();
    }

    public void process() {
        this.getNode().clusterManager.handleJoinRequest(this);
    }
}

