/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.config.Config;
import com.hazelcast.impl.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.util.Collection;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressPicker {
    final Node node;
    final ServerSocketChannel serverSocketChannel;
    final ILogger logger;

    public AddressPicker(Node node, ServerSocketChannel serverSocketChannel) {
        this.node = node;
        this.logger = Logger.getLogger(AddressPicker.class.getName());
        this.serverSocketChannel = serverSocketChannel;
    }

    public static boolean matchAddress(String address, Collection<String> interfaces) {
        int[] ip = new int[4];
        int i = 0;
        StringTokenizer st = new StringTokenizer(address, ".");
        while (st.hasMoreTokens()) {
            ip[i++] = Integer.parseInt(st.nextToken());
        }
        for (String ipmask : interfaces) {
            if (!AddressPicker.matchAddress(ipmask, ip)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchAddress(String ipmask, int[] ip) {
        String[] ips = new String[4];
        StringTokenizer st = new StringTokenizer(ipmask, ".");
        int i = 0;
        while (st.hasMoreTokens()) {
            ips[i++] = st.nextToken();
        }
        for (int a = 0; a < 4; ++a) {
            String mask = ips[a];
            int ipa = ip[a];
            int dashIndex = mask.indexOf(45);
            if (mask.equals("*")) continue;
            if (dashIndex != -1) {
                int start = Integer.parseInt(mask.substring(0, dashIndex).trim());
                int end = Integer.parseInt(mask.substring(dashIndex + 1).trim());
                if (ipa >= start && ipa <= end) continue;
                return false;
            }
            int x = Integer.parseInt(mask);
            if (x == ipa) continue;
            return false;
        }
        return true;
    }

    public Address pickAddress() throws Exception {
        String currentAddress = null;
        try {
            Config config = this.node.getConfig();
            String localAddress = System.getProperty("hazelcast.local.lockAddress");
            if (localAddress != null) {
                currentAddress = InetAddress.getByName(localAddress.trim()).getHostAddress();
            }
            if (currentAddress == null) {
                Enumeration<NetworkInterface> enums = NetworkInterface.getNetworkInterfaces();
                block4: while (enums.hasMoreElements()) {
                    NetworkInterface ni = enums.nextElement();
                    Enumeration<InetAddress> e = ni.getInetAddresses();
                    while (e.hasMoreElements()) {
                        InetAddress inetAddress = e.nextElement();
                        if (!(inetAddress instanceof Inet4Address)) continue;
                        String address = inetAddress.getHostAddress();
                        Collection<String> interfaces = config.getNetworkConfig().getInterfaces().getInterfaces();
                        if (config.getNetworkConfig().getInterfaces().isEnabled()) {
                            if (!AddressPicker.matchAddress(address, interfaces)) continue;
                            currentAddress = address;
                            break block4;
                        }
                        if (inetAddress.isLoopbackAddress()) continue;
                        currentAddress = address;
                        break block4;
                    }
                }
                if (config.getNetworkConfig().getInterfaces().isEnabled() && currentAddress == null) {
                    String msg = "Hazelcast CANNOT start on this node. No matching network interface found. ";
                    msg = msg + "\nInterface matching must be either disabled or updated in the hazelcast.xml config file.";
                    this.logger.log(Level.SEVERE, msg);
                    throw new RuntimeException(msg);
                }
            }
            if (currentAddress == null) {
                currentAddress = "127.0.0.1";
            }
            InetAddress inetAddress = InetAddress.getByName(currentAddress);
            boolean reuseAddress = config.isReuseAddress();
            ServerSocket serverSocket = this.serverSocketChannel.socket();
            serverSocket.setReuseAddress(reuseAddress);
            int port = config.getPort();
            for (int i = 0; i < 100; ++i) {
                try {
                    boolean bindAny = this.node.getGroupProperties().SOCKET_BIND_ANY.getBoolean();
                    InetSocketAddress isa = bindAny ? new InetSocketAddress(port) : new InetSocketAddress(inetAddress, port);
                    serverSocket.bind(isa, 100);
                    break;
                }
                catch (Exception e) {
                    if (config.isPortAutoIncrement()) {
                        serverSocket = this.serverSocketChannel.socket();
                        serverSocket.setReuseAddress(reuseAddress);
                        ++port;
                        continue;
                    }
                    String msg = "Port [" + port + "] is already in use and auto-increment is " + "disabled. Hazelcast cannot start.";
                    this.logger.log(Level.SEVERE, msg);
                    throw e;
                }
            }
            this.serverSocketChannel.configureBlocking(false);
            return new Address(currentAddress, port);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }
}

