/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.Member;
import com.hazelcast.impl.BaseManager;
import com.hazelcast.impl.CallContext;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.Constants;
import com.hazelcast.impl.ExecutionManagerCallback;
import com.hazelcast.impl.ExecutorThreadFactory;
import com.hazelcast.impl.GroupProperties;
import com.hazelcast.impl.InnerFutureTask;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.NamedExecutorService;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.Request;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.executor.ParallelExecutor;
import com.hazelcast.impl.executor.ParallelExecutorService;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.partition.Partition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

public class ExecutorManager
extends BaseManager {
    private final ConcurrentMap<String, NamedExecutorService> mapExecutors = new ConcurrentHashMap<String, NamedExecutorService>(10);
    private final ConcurrentMap<Thread, CallContext> mapThreadCallContexts = new ConcurrentHashMap<Thread, CallContext>(100);
    private final NamedExecutorService defaultExecutorService;
    private final NamedExecutorService clientExecutorService;
    private final NamedExecutorService migrationExecutorService;
    private final NamedExecutorService queryExecutorService;
    private final NamedExecutorService storeExecutorService;
    private final NamedExecutorService eventExecutorService;
    private volatile boolean started = false;
    private static final String DEFAULT_EXECUTOR_SERVICE = "x:default";
    private static final String CLIENT_EXECUTOR_SERVICE = "x:hz.client";
    private static final String MIGRATION_EXECUTOR_SERVICE = "x:hz.migration";
    private static final String QUERY_EXECUTOR_SERVICE = "x:hz.query";
    private static final String STORE_EXECUTOR_SERVICE = "x:hz.store";
    private static final String EVENT_EXECUTOR_SERVICE = "x:hz.events";
    private final Object CREATE_LOCK = new Object();
    private final ParallelExecutorService parallelExecutorService;
    private final ThreadPoolExecutor threadPoolExecutor;

    ExecutorManager(final Node node) {
        super(node);
        this.logger.log(Level.FINEST, "Starting ExecutorManager");
        GroupProperties gp = node.groupProperties;
        ClassLoader classLoader = node.getConfig().getClassLoader();
        this.threadPoolExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue(), new ExecutorThreadFactory(node.threadGroup, this.getThreadNamePrefix("cached"), classLoader), new RejectionHandler()){

            protected void beforeExecute(Thread t, Runnable r) {
                ThreadContext threadContext = ThreadContext.get();
                CallContext callContext = (CallContext)ExecutorManager.this.mapThreadCallContexts.get(t);
                if (callContext == null) {
                    callContext = new CallContext(threadContext.createNewThreadId(), false);
                    ExecutorManager.this.mapThreadCallContexts.put(t, callContext);
                }
                threadContext.setCurrentFactory(node.factory);
                threadContext.setCallContext(callContext);
            }
        };
        this.parallelExecutorService = new ParallelExecutorService(this.threadPoolExecutor);
        this.defaultExecutorService = this.getOrCreateNamedExecutorService(DEFAULT_EXECUTOR_SERVICE);
        this.clientExecutorService = this.getOrCreateNamedExecutorService(CLIENT_EXECUTOR_SERVICE, gp.EXECUTOR_CLIENT_THREAD_COUNT);
        this.migrationExecutorService = this.getOrCreateNamedExecutorService(MIGRATION_EXECUTOR_SERVICE, gp.EXECUTOR_MIGRATION_THREAD_COUNT);
        this.queryExecutorService = this.getOrCreateNamedExecutorService(QUERY_EXECUTOR_SERVICE, gp.EXECUTOR_QUERY_THREAD_COUNT);
        this.storeExecutorService = this.getOrCreateNamedExecutorService(STORE_EXECUTOR_SERVICE, gp.EXECUTOR_STORE_THREAD_COUNT);
        this.eventExecutorService = this.getOrCreateNamedExecutorService(EVENT_EXECUTOR_SERVICE, gp.EXECUTOR_EVENT_THREAD_COUNT);
        this.registerPacketProcessor(ClusterOperation.EXECUTE, new ExecutionOperationHandler());
        this.started = true;
    }

    public NamedExecutorService getOrCreateNamedExecutorService(String name) {
        return this.getOrCreateNamedExecutorService(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NamedExecutorService getOrCreateNamedExecutorService(String name, GroupProperties.GroupProperty groupProperty) {
        NamedExecutorService namedExecutorService = (NamedExecutorService)this.mapExecutors.get(name);
        if (namedExecutorService == null) {
            Object object = this.CREATE_LOCK;
            synchronized (object) {
                namedExecutorService = (NamedExecutorService)this.mapExecutors.get(name);
                if (namedExecutorService == null) {
                    ExecutorConfig executorConfig = this.node.getConfig().getExecutorConfig(name.substring(2));
                    if (groupProperty != null) {
                        executorConfig.setCorePoolSize(groupProperty.getInteger());
                        executorConfig.setMaxPoolSize(groupProperty.getInteger());
                    }
                    namedExecutorService = this.newNamedExecutorService(name, executorConfig);
                }
            }
        }
        return namedExecutorService;
    }

    public String getThreadNamePrefix(String executorServiceName) {
        return "hz.executor." + this.node.getName() + "." + executorServiceName + ".thread-";
    }

    private NamedExecutorService newNamedExecutorService(String name, ExecutorConfig executorConfig) {
        this.logger.log(Level.FINEST, "creating new named executor service " + name);
        int concurrencyLevel = executorConfig.getMaxPoolSize();
        ParallelExecutor parallelExecutor = this.parallelExecutorService.newParallelExecutor(concurrencyLevel);
        NamedExecutorService es = new NamedExecutorService(name, parallelExecutor);
        this.mapExecutors.put(name, es);
        return es;
    }

    public ParallelExecutor newParallelExecutor(int concurrencyLevel) {
        return this.parallelExecutorService.newParallelExecutor(concurrencyLevel);
    }

    public boolean isStarted() {
        return this.started;
    }

    public void appendState(StringBuffer sbState) {
        Set names = this.mapExecutors.keySet();
        for (String name : names) {
            NamedExecutorService namedExecutorService = (NamedExecutorService)this.mapExecutors.get(name);
            namedExecutorService.appendState(sbState);
        }
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        this.parallelExecutorService.shutdown();
        Collection executors = this.mapExecutors.values();
        for (NamedExecutorService namedExecutorService : executors) {
            namedExecutorService.stop();
        }
        this.threadPoolExecutor.shutdownNow();
        try {
            this.threadPoolExecutor.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.started = false;
    }

    public NamedExecutorService getDefaultExecutorService() {
        return this.defaultExecutorService;
    }

    public NamedExecutorService getClientExecutorService() {
        return this.clientExecutorService;
    }

    public NamedExecutorService getEventExecutorService() {
        return this.eventExecutorService;
    }

    public void executeLocally(Runnable runnable) {
        this.defaultExecutorService.execute(runnable);
    }

    public void executeNow(Runnable runnable) {
        this.threadPoolExecutor.execute(runnable);
    }

    public void executeMigrationTask(Runnable runnable) {
        this.migrationExecutorService.execute(runnable);
    }

    public void executeQueryTask(Runnable runnable) {
        this.queryExecutorService.execute(runnable);
    }

    public void executeStoreTask(Runnable runnable) {
        this.storeExecutorService.execute(runnable);
    }

    public void call(String name, DistributedTask dtask) {
        NamedExecutorService namedExecutorService = this.getOrCreateNamedExecutorService(name);
        InnerFutureTask inner = (InnerFutureTask)dtask.getInner();
        Data callable = IOUtil.toData(inner.getCallable());
        if (inner.getMembers() != null) {
            Set<Member> members = inner.getMembers();
            if (members.size() == 1) {
                MemberCall memberCall = new MemberCall(name, (MemberImpl)members.iterator().next(), callable, dtask);
                inner.setExecutionManagerCallback(memberCall);
                memberCall.call();
            } else {
                MembersCall membersCall = new MembersCall(name, members, callable, dtask);
                inner.setExecutionManagerCallback(membersCall);
                membersCall.call();
            }
        } else if (inner.getMember() != null) {
            MemberCall memberCall = new MemberCall(name, (MemberImpl)inner.getMember(), callable, dtask);
            inner.setExecutionManagerCallback(memberCall);
            memberCall.call();
        } else if (inner.getKey() != null) {
            Partition partition = this.node.factory.getPartitionService().getPartition(inner.getKey());
            Member target = partition.getOwner();
            if (target == null) {
                target = this.node.factory.getCluster().getMembers().iterator().next();
            }
            MemberCall memberCall = new MemberCall(name, (MemberImpl)target, callable, dtask);
            inner.setExecutionManagerCallback(memberCall);
            memberCall.call();
        } else {
            MemberImpl target = (MemberImpl)namedExecutorService.getExecutionLoadBalancer().getTarget(this.node.factory);
            MemberCall memberCall = new MemberCall(name, target, callable, dtask);
            inner.setExecutionManagerCallback(memberCall);
            memberCall.call();
        }
    }

    void notifyCompletion(final DistributedTask dtask) {
        final InnerFutureTask innerFutureTask = (InnerFutureTask)dtask.getInner();
        this.getEventExecutorService().execute(new Runnable(){

            public void run() {
                innerFutureTask.innerDone();
                if (innerFutureTask.getExecutionCallback() != null) {
                    innerFutureTask.getExecutionCallback().done(dtask);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object toObjectWithConfigClassLoader(Data data) {
        ClassLoader actualContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.node.getConfig().getClassLoader());
            Object object = IOUtil.toObject(data);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(actualContextClassLoader);
        }
    }

    class MemberCall
    extends BaseManager.TargetAwareOp
    implements ExecutionManagerCallback {
        final String name;
        final MemberImpl member;
        final Data callable;
        final DistributedTask dtask;
        final InnerFutureTask innerFutureTask;
        final boolean singleTask;
        final ExecutionListener executionListener;

        MemberCall(String name, MemberImpl member, Data callable, DistributedTask dtask) {
            this(name, member, callable, dtask, true, null);
        }

        MemberCall(String name, MemberImpl member, Data callable, DistributedTask dtask, boolean singleTask, ExecutionListener executionListener) {
            this.name = name;
            this.member = member;
            this.callable = callable;
            this.dtask = dtask;
            this.innerFutureTask = (InnerFutureTask)dtask.getInner();
            this.singleTask = singleTask;
            this.target = member.getAddress();
            this.executionListener = executionListener;
        }

        public void call() {
            this.request.setLocal(ClusterOperation.EXECUTE, this.name, null, this.callable, -1, -1L, -1L, ExecutorManager.this.thisAddress);
            this.doOp();
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new UnsupportedOperationException();
        }

        public void get() throws InterruptedException {
            this.get(-1L, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void get(long time, TimeUnit unit) throws InterruptedException {
            try {
                Object result = this.doGetResult(time == -1L ? -1L : unit.toMillis(time));
                if (result == Constants.Objects.OBJECT_MEMBER_LEFT) {
                    this.innerFutureTask.innerSetMemberLeft(this.member);
                } else if (result instanceof Throwable) {
                    this.innerFutureTask.innerSetException((Throwable)result);
                } else {
                    this.innerFutureTask.innerSet(result);
                }
            }
            catch (Exception e) {
                this.innerFutureTask.innerSetException(e);
            }
            finally {
                if (this.singleTask) {
                    this.innerFutureTask.innerDone();
                }
            }
        }

        public Object doGetResult(long timeoutMillis) throws InterruptedException {
            Object result;
            Object object = result = timeoutMillis == -1L ? this.getResult() : this.getResult(timeoutMillis, TimeUnit.MILLISECONDS);
            if (result == null) {
                result = new TimeoutException();
            }
            if (result == Constants.Objects.OBJECT_NULL) {
                result = null;
            } else if (result instanceof Data) {
                Data data = (Data)result;
                result = data.size() == 0 ? null : ExecutorManager.this.toObjectWithConfigClassLoader(data);
            }
            this.afterGettingResult(this.request);
            return result;
        }

        public void onDisconnect(Address dead) {
            if (dead.equals(this.target)) {
                this.setResult(Constants.Objects.OBJECT_MEMBER_LEFT);
            }
        }

        public void packetNotSent() {
            this.setResult(Constants.Objects.OBJECT_MEMBER_LEFT);
        }

        public void onResponse(Object response) {
            if (this.singleTask) {
                ExecutorManager.this.notifyCompletion(this.dtask);
            }
        }

        public void setResult(Object result) {
            super.setResult(result);
            if (this.executionListener != null) {
                this.executionListener.onResponse(result);
            }
            this.onResponse(result);
        }

        public void setTarget() {
            this.target = this.member.getAddress();
        }
    }

    static interface ExecutionListener {
        public void onResponse(Object var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MembersCall
    implements ExecutionManagerCallback,
    ExecutionListener {
        final DistributedTask dtask;
        final String name;
        final Set<Member> members;
        final Data callable;
        final InnerFutureTask innerFutureTask;
        final List<MemberCall> lsMemberCalls = new ArrayList<MemberCall>();
        int responseCount = 0;

        MembersCall(String name, Set<Member> members, Data callable, DistributedTask dtask) {
            this.name = name;
            this.members = members;
            this.callable = callable;
            this.dtask = dtask;
            this.innerFutureTask = (InnerFutureTask)dtask.getInner();
        }

        void call() {
            for (Member member : this.members) {
                MemberCall memberCall = new MemberCall(this.name, (MemberImpl)member, this.callable, this.dtask, false, this);
                this.lsMemberCalls.add(memberCall);
                memberCall.call();
            }
        }

        @Override
        public void onResponse(Object result) {
            ++this.responseCount;
            if (result == Constants.Objects.OBJECT_MEMBER_LEFT || this.responseCount >= this.lsMemberCalls.size()) {
                ExecutorManager.this.notifyCompletion(this.dtask);
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void get() throws InterruptedException, ExecutionException {
            this.doGet(-1L);
        }

        @Override
        public void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
            this.doGet(unit.toMillis(timeout));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doGet(long timeoutMillis) {
            long remainingMillis = timeoutMillis;
            try {
                for (MemberCall memberCall : this.lsMemberCalls) {
                    long now = System.currentTimeMillis();
                    if (timeoutMillis == -1L) {
                        memberCall.get();
                    } else {
                        if (remainingMillis < 0L) {
                            this.innerFutureTask.innerSetException(new TimeoutException());
                            return;
                        }
                        memberCall.get(remainingMillis, TimeUnit.MILLISECONDS);
                    }
                    remainingMillis -= System.currentTimeMillis() - now;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.innerFutureTask.innerSetException(e);
            }
            finally {
                this.innerFutureTask.innerDone();
            }
        }
    }

    class RejectionHandler
    implements RejectedExecutionHandler {
        RejectionHandler() {
        }

        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            ExecutorManager.this.logger.log(Level.WARNING, "ExecutorService is rejecting an execution. " + runnable);
        }
    }

    class RequestExecutor
    implements Runnable {
        final Request request;

        RequestExecutor(Request request) {
            this.request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Data result = null;
            try {
                Callable callable = (Callable)IOUtil.toObject(this.request.value);
                result = callable.call();
                result = IOUtil.toData(result);
            }
            catch (Throwable e) {
                result = IOUtil.toData(e);
            }
            finally {
                this.request.clearForResponse();
                this.request.response = result;
                ExecutorManager.this.enqueueAndReturn(new BaseManager.ReturnResponseProcess(this.request));
            }
        }
    }

    class ExecutionOperationHandler
    extends BaseManager.AbstractOperationHandler {
        ExecutionOperationHandler() {
        }

        void doOperation(Request request) {
            NamedExecutorService namedExecutorService = ExecutorManager.this.getOrCreateNamedExecutorService(request.name);
            namedExecutorService.execute(new RequestExecutor(request));
        }

        public void handle(Request request) {
            this.doOperation(request);
        }
    }
}

