/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.impl.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Connection;
import java.io.IOException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public abstract class SelectorBase
implements Runnable {
    protected final ILogger logger;
    protected final Selector selector;
    protected final Queue<Runnable> selectorQueue = new ConcurrentLinkedQueue<Runnable>();
    protected final Node node;
    protected final AtomicInteger size = new AtomicInteger();
    private final int waitTime;
    protected boolean live = true;

    public SelectorBase(Node node, int waitTime) {
        this.node = node;
        this.logger = node.getLogger(this.getClass().getName());
        this.waitTime = waitTime;
        Selector selectorTemp = null;
        try {
            selectorTemp = Selector.open();
        }
        catch (IOException e) {
            this.handleSelectorException(e);
        }
        this.selector = selectorTemp;
        this.live = true;
    }

    public void shutdown() {
        if (this.selectorQueue != null) {
            this.selectorQueue.clear();
        }
        try {
            final CountDownLatch l = new CountDownLatch(1);
            this.addTask(new Runnable(){

                public void run() {
                    SelectorBase.this.live = false;
                    l.countDown();
                }
            });
            l.await(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int addTask(Runnable runnable) {
        this.selectorQueue.offer(runnable);
        return this.size.incrementAndGet();
    }

    abstract void processSelectionQueue();

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 23[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void handleSelectorException(Exception e) {
        String msg = "Selector exception at  " + Thread.currentThread().getName();
        msg = msg + ", cause= " + e.toString();
        this.logger.log(Level.FINEST, msg, e);
    }

    protected Connection initChannel(SocketChannel socketChannel, boolean acceptor) throws Exception {
        socketChannel.socket().setReceiveBufferSize(32768);
        socketChannel.socket().setSendBufferSize(32768);
        socketChannel.socket().setKeepAlive(true);
        socketChannel.configureBlocking(false);
        return this.node.connectionManager.createConnection(socketChannel, acceptor);
    }
}

