/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.ascii;

import com.hazelcast.impl.Node;
import com.hazelcast.impl.ascii.CommandParser;
import com.hazelcast.impl.ascii.TextCommand;
import com.hazelcast.impl.ascii.TextCommandConstants;
import com.hazelcast.impl.ascii.TextCommandService;
import com.hazelcast.impl.ascii.memcache.DeleteCommandParser;
import com.hazelcast.impl.ascii.memcache.ErrorCommand;
import com.hazelcast.impl.ascii.memcache.GetCommandParser;
import com.hazelcast.impl.ascii.memcache.SetCommandParser;
import com.hazelcast.impl.ascii.memcache.SimpleCommandParser;
import com.hazelcast.impl.ascii.rest.HttpCommand;
import com.hazelcast.impl.ascii.rest.HttpDeleteCommandParser;
import com.hazelcast.impl.ascii.rest.HttpGetCommandParser;
import com.hazelcast.impl.ascii.rest.HttpPostCommandParser;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.SocketReader;
import com.hazelcast.nio.ascii.SocketTextWriter;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class SocketTextReader
implements TextCommandConstants,
SocketReader {
    private static final Map<String, CommandParser> mapCommandParsers = new HashMap<String, CommandParser>();
    ByteBuffer commandLine = ByteBuffer.allocate(500);
    boolean commandLineRead = false;
    TextCommand command = null;
    private final TextCommandService textCommandService;
    private final SocketTextWriter socketTextWriter;
    private final Connection connection;
    long requestIdGen;
    boolean connectionTypeSet = false;

    public SocketTextReader(Node node, Connection connection) {
        this.textCommandService = node.getTextCommandService();
        this.socketTextWriter = (SocketTextWriter)connection.getWriteHandler().getSocketWriter();
        this.connection = connection;
    }

    public void sendResponse(TextCommand command) {
        this.socketTextWriter.enqueue(command);
    }

    public void read(ByteBuffer inBuffer) {
        while (inBuffer.hasRemaining()) {
            this.doRead(inBuffer);
        }
    }

    private void doRead(ByteBuffer bb) {
        while (!this.commandLineRead && bb.hasRemaining()) {
            byte b = bb.get();
            char c = (char)b;
            if (c == '\n') {
                this.commandLineRead = true;
                continue;
            }
            if (c == '\r') continue;
            this.commandLine.put(b);
        }
        if (this.commandLineRead) {
            if (this.command == null) {
                this.processCmd(SocketTextReader.toStringAndClear(this.commandLine));
            }
            if (this.command != null) {
                boolean complete = this.command.doRead(bb);
                if (complete) {
                    this.publishRequest(this.command);
                    this.reset();
                }
            } else {
                this.reset();
            }
        }
    }

    void reset() {
        this.command = null;
        this.commandLine.clear();
        this.commandLineRead = false;
    }

    public static String toStringAndClear(ByteBuffer bb) {
        if (bb == null) {
            return "";
        }
        String result = null;
        result = bb.position() == 0 ? "" : new String(bb.array(), 0, bb.position());
        bb.clear();
        return result;
    }

    public void publishRequest(TextCommand command) {
        long l;
        if (!this.connectionTypeSet) {
            if (command instanceof HttpCommand) {
                this.connection.setType(Connection.Type.REST_CLIENT);
            } else {
                this.connection.setType(Connection.Type.MEMCACHE_CLIENT);
            }
            this.connectionTypeSet = true;
        }
        if (command.shouldReply()) {
            long l2 = this.requestIdGen;
            l = l2;
            this.requestIdGen = l2 + 1L;
        } else {
            l = -1L;
        }
        long requestId = l;
        command.init(this, requestId);
        this.textCommandService.processRequest(command);
    }

    void processCmd(String cmd) {
        try {
            int space = cmd.indexOf(32);
            String operation = space == -1 ? cmd : cmd.substring(0, space);
            CommandParser commandParser = mapCommandParsers.get(operation);
            this.command = commandParser != null ? commandParser.parser(this, cmd, space) : new ErrorCommand(TextCommandConstants.TextCommandType.UNKNOWN);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.command = new ErrorCommand(TextCommandConstants.TextCommandType.ERROR_CLIENT, "Invalid command : " + cmd);
        }
    }

    public SocketTextWriter getSocketTextWriter() {
        return this.socketTextWriter;
    }

    public void closeConnection() {
        this.connection.close();
    }

    static {
        mapCommandParsers.put("get", new GetCommandParser());
        mapCommandParsers.put("gets", new GetCommandParser());
        mapCommandParsers.put("set", new SetCommandParser(TextCommandConstants.TextCommandType.SET));
        mapCommandParsers.put("add", new SetCommandParser(TextCommandConstants.TextCommandType.ADD));
        mapCommandParsers.put("replace", new SetCommandParser(TextCommandConstants.TextCommandType.REPLACE));
        mapCommandParsers.put("append", new SetCommandParser(TextCommandConstants.TextCommandType.APPEND));
        mapCommandParsers.put("prepend", new SetCommandParser(TextCommandConstants.TextCommandType.PREPEND));
        mapCommandParsers.put("delete", new DeleteCommandParser());
        mapCommandParsers.put("quit", new SimpleCommandParser(TextCommandConstants.TextCommandType.QUIT));
        mapCommandParsers.put("stats", new SimpleCommandParser(TextCommandConstants.TextCommandType.STATS));
        mapCommandParsers.put("GET", new HttpGetCommandParser());
        mapCommandParsers.put("POST", new HttpPostCommandParser());
        mapCommandParsers.put("PUT", new HttpPostCommandParser());
        mapCommandParsers.put("DELETE", new HttpDeleteCommandParser());
    }
}

