/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query;

import com.hazelcast.core.MapEntry;
import com.hazelcast.impl.Record;
import com.hazelcast.query.IndexStore;
import com.hazelcast.query.MultiResultSet;
import com.hazelcast.query.SingleResultSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsortedIndexStore
implements IndexStore {
    private final ConcurrentMap<Long, ConcurrentMap<Long, Record>> mapRecords = new ConcurrentHashMap<Long, ConcurrentMap<Long, Record>>(100, 0.75f, 1);

    @Override
    public void getSubRecordsBetween(MultiResultSet results, long from, long to) {
        Set values = this.mapRecords.keySet();
        for (Long value : values) {
            ConcurrentMap records;
            if (value < from || value > to || (records = (ConcurrentMap)this.mapRecords.get(value)) == null) continue;
            results.addResultSet(value, records.values());
        }
    }

    @Override
    public void getSubRecords(MultiResultSet results, boolean equal, boolean lessThan, long searchedValue) {
        Set values = this.mapRecords.keySet();
        for (Long value : values) {
            ConcurrentMap records;
            boolean valid;
            if (lessThan) {
                valid = equal ? value <= searchedValue : value < searchedValue;
            } else {
                boolean bl = equal ? value >= searchedValue : (valid = value > searchedValue);
            }
            if (!valid || (records = (ConcurrentMap)this.mapRecords.get(value)) == null) continue;
            results.addResultSet(value, records.values());
        }
    }

    @Override
    public void newRecordIndex(long newValue, Record record) {
        long recordId = record.getId();
        ConcurrentHashMap<Long, Record> records = (ConcurrentHashMap<Long, Record>)this.mapRecords.get(newValue);
        if (records == null) {
            records = new ConcurrentHashMap<Long, Record>(1, 0.75f, 1);
            this.mapRecords.put(newValue, records);
        }
        records.put(recordId, record);
    }

    @Override
    public void removeRecordIndex(long oldValue, long recordId) {
        ConcurrentMap records = (ConcurrentMap)this.mapRecords.get(oldValue);
        if (records != null) {
            records.remove(recordId);
            if (records.size() == 0) {
                this.mapRecords.remove(oldValue);
            }
        }
    }

    @Override
    public Set<MapEntry> getRecords(long value) {
        return new SingleResultSet((ConcurrentMap)this.mapRecords.get(value));
    }

    @Override
    public void getRecords(MultiResultSet results, long[] values) {
        long[] arr$ = values;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Long value = arr$[i$];
            ConcurrentMap records = (ConcurrentMap)this.mapRecords.get(value);
            if (records == null) continue;
            results.addResultSet(value, records.values());
        }
    }

    @Override
    public ConcurrentMap<Long, ConcurrentMap<Long, Record>> getMapRecords() {
        return this.mapRecords;
    }

    public String toString() {
        return "UnsortedIndexStore{mapRecords=" + this.mapRecords.size() + '}';
    }
}

